package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Node of a singly-linked list.
*
*/
public class SinglyLinkedListNodeReplica<Element> extends AbstractGenericObjectReplica {
	
	protected Element value;
	protected SinglyLinkedListNodeReplica<Element> next;
	
	public SinglyLinkedListNodeReplica() {
		super( 1 );
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings("unchecked")
	public SpecializedClass<Element> getValueClass()	{
		return (SpecializedClass<Element>) typeParameters[0];
	}

	/** Get stored value
	 */ 
	public Element getValue() {
		return value;
	}
	
	/** Get next node
	 */
	public SinglyLinkedListNodeReplica<Element> getNext() {
		return next;
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicableObject#receive(cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream)
	 */
	@SuppressWarnings("unchecked")
	public void receive( IInputObjectStream inputStream )	{
		value = (Element) PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), inputStream );
		next = (SinglyLinkedListNodeReplica<Element>) inputStream.readObjectRef();
		assert( next == null || next.getValueClass().equals( getValueClass() ) );
	}
}
