package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Singly-linked list core
 * 
 */
public class SinglyLinkedListCoreReplica<Element> extends AbstractGenericObjectReplica {
	
	protected SinglyLinkedListNodeReplica<Element> head;
	protected SinglyLinkedListNodeReplica<Element> last;
	protected int size;

	public SinglyLinkedListCoreReplica() {
		super( 1 );
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings("unchecked")
	public SpecializedClass<Element> getValueClass() {
		return (SpecializedClass<Element>) typeParameters[0];
	}
	
	/** Get head node
	 *
	 * @return head node
	 */
	public SinglyLinkedListNodeReplica<Element> getHead() {
		return head;
	}

	/** Get last node
	 *
	 * @return last node or null if list is empty
	 */
	public SinglyLinkedListNodeReplica<Element> getLast() {
		return last;
	}
	
	/** Get list size
	 */
	public int getSize() {
		return size;
	}
		
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicableObject#receive(cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream)
	 */
	@SuppressWarnings("unchecked")
	public void receive( IInputObjectStream inputStream )
	{
		head = (SinglyLinkedListNodeReplica<Element>) inputStream.readObjectRef();
		assert( head.getValueClass().equals( getValueClass() ) );
		last = (SinglyLinkedListNodeReplica<Element>) inputStream.readObjectRef();
		assert( last == null || last.getValueClass().equals( getValueClass() ) );
		size = inputStream.readInt();
	}

}
