package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Boxed primitive type
*
* Supports reference types too.
*/
public class PrimitiveBoxReplica<Primitive> extends AbstractGenericObjectReplica {

	protected Primitive value;
	
	public PrimitiveBoxReplica() {
		super(1);
	}
	
	/** Constructor
	 * 
	 * @param valueClass value type parameter
	 * @param value value
	 */
	public PrimitiveBoxReplica( Class<Primitive> valueClass, Primitive value ) {
		super(1);
		setTypeParameter( 0, SpecializedClass.fromPlain( valueClass ) );
		this.value = value;
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings({ "unchecked" })
	public SpecializedClass<Primitive> getValueClass() {
		return (SpecializedClass<Primitive>) typeParameters[0];
	}
	
	/** Get boxed value
	 *
	 * @return boxed value
	 */
	public Primitive get() {
		return value;
	}
		
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicableObject#receive(cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void receive( IInputObjectStream inputStream )
	{
		value = (Primitive) PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), inputStream );
	}
}