package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Mapping entry of a list map
*/
public class ListMapEntryReplica<ValueType> extends AbstractGenericObjectReplica {

	protected String key;
	protected ValueType value;
	
	public ListMapEntryReplica() {
		super(1);
	}
	
	public ListMapEntryReplica( String key, ValueType value ) {
		super(1);
		this.key = key;
		this.value = value;
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings("unchecked")
	public SpecializedClass<ValueType> getValueClass() {
		return (SpecializedClass<ValueType>) typeParameters[0];
	}

	/** Get value of the mapping
	 */
	public ValueType getValue() {
		return value;
	}
	
	/** Get key of the mapping
	 */
	public String getKey() {
		return key;
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicableObject#receive(cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream)
	 */
	@SuppressWarnings("unchecked")
	public void receive( IInputObjectStream inputStream )
	{
		key = inputStream.readString();
		value = (ValueType) PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), inputStream );
	}
}