package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist;

import java.util.Collection;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;

/** Foggy reference list attribute view inteface
 */
public interface IFoggyRefListAttributeView {

	/** Get read-only value list of an existing attribute
	 * 
	 * Not available for write attributes on client-side.
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value list
	 */
	 Collection<FoggyRefReplica> read( String attributeName );
	
	/** Set value list of an existing remote attribute
	 *
	 * Available only for write attributes on client-side.
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value list that shall be copied to the attribute
	 */
	void send( String attributeName, Iterable<IObjectReplica> value );
	
	/** Tell if attribute exists and has the right type and access
	 * 
	 * @param attributeName attribute name
	 * @param access required access
	 * @return true if attribute exists and has the right type, false otherwise
	 */
	boolean exists( String attributeName, AttributeAccess access );
	
	/** Iterate over attributes in the view
	 *
	 * @return read-only iterator over attributes in the view
	 */
	Iterator<ListMapEntryReplica<FoggyRefListAttributeReplica>> iterator();
}