package cz.cuni.amis.pogamut.emohawk.communication.attribute;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;

/** Command to set attribute value
 * 
 * NOTE: This command only tells which attributes to set.
 * The new value of the attribute has to be transmitted by the primitive data stream prior to this message.
 * 
 * @author Paletz
 */
public class SetAttribute extends CommandMessage {
	
	protected ReplicationId replicationId;
	
    public SetAttribute( ReplicationId replicationId ) {
        this.replicationId = replicationId;
    }
 
    public SetAttribute() {
    	this( new ReplicationId( -1, 0 ) );
    }
 
    public SetAttribute( SetAttribute original) {
        this( original.getReplicationId() );
    }
 
    
    /** Get the replication ID
     * 
	 * @return the replication ID
	 */
	public ReplicationId getReplicationId() {
		return replicationId;
	}

	/** Set replication ID
	 * 
	 * @param replicationId the replication Id to set
	 */
	public void setReplicationId( ReplicationId replicationId) {
		this.replicationId = replicationId;
	}
	
	/** Convert to string
	 * 
	 * @return string representation that can be sent to gamebots
	 */
	@Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append( "SATTR " );
        buf.append( replicationId.toGbMessageParameter( "Attr" ) );
        return buf.toString();
    }
 }
