package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

public class FoggyRefReplica extends AbstractObjectReplica {
	
	protected int referenceIndex;
	
	public FoggyRefReplica() {
		super();
	}
	
	/** Get referenced value
	 * 
	 * It is an error to get() hidden reference on client-side.
	 * 
	 * @return referenced object
	 */
	public IObjectReplica get()
	{
		if ( referenceIndex == -1 )
		{
			return null;
		}
		else
		{
			assert( objectReplicationClient.exists( referenceIndex ) );
			return objectReplicationClient.getObject( referenceIndex );
		}
	}

	/** Tell if referenced object is hidden
	 *  
	 * @return false if reference is null or the referenced object is replicated, true if the referenced object is not replicated
	 */
	public boolean isHidden()
	{
		return referenceIndex != -1 && !objectReplicationClient.exists( referenceIndex );
	}
	
	@Override
	public void receive( IInputObjectStream stream ) {
		referenceIndex = stream.readInt();
	}
}
