package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
	
/** Interface of view of foggy reference attributes
 * 
 * Provides add, remove, exists, isHidden, get and set operations. 
 */
public interface IFoggyRefAttributeView {
	
	/** Tell if referenced object is hidden
	 *
	 * @return true if referenced object is hidden
	 */
	boolean isHidden( String attributeName );
	
	/** Get value of an existing attribute
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @return attribute value
	 */
	IObjectReplica get( String attributeName );
	
	/** Set value of an existing attribute
	 *
	 * @param attributeName attribute name, must exist and have the right type
	 * @param value new value
	 */
	void set( String attributeName, IObjectReplica value );
	
	/** Tell if attribute exists and has the right type and access
	 *
	 * @param attributeName attribute name
	 * @param access required access
	 * @return true if attribute exists and has the right type, false otherwise
	 */
	boolean exists( String attributeName, AttributeAccess access );
	
	/** Iterate over attributes in the view
	 *
	 * @return read-only iterator over attributes in the view
	 */
	Iterator<ListMapEntryReplica<FoggyRefAttributeReplica>> iterator();
}