/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.IPrimitiveAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.PrimitiveAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveBoxReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import java.util.Arrays;
import java.util.Iterator;

public class PrimitiveAttributeView<T>
implements IPrimitiveAttributeView<T> {
    protected AttributeRawView<PrimitiveAttributeReplication<T>, T> rawView;
    protected Class<T> primitiveClass;

    public PrimitiveAttributeView(Class<T> primitiveClass, ListMapReplication<IAttributeReplication> attributes, AttributeUpstream upstream) {
        this.primitiveClass = primitiveClass;
        this.rawView = new AttributeRawView(attributes, upstream, new SpecializedClass<PrimitiveAttributeReplication>(PrimitiveAttributeReplication.class, Arrays.asList(SpecializedClass.fromPlain(primitiveClass))));
    }

    @Override
    public T get(String attributeName) {
        PrimitiveAttributeReplication<T> attribute = this.rawView.getAttributeRecord(attributeName);
        PrimitiveBoxReplication<T> pbox = attribute.getValue();
        assert (pbox.getValueClass().equals(SpecializedClass.fromPlain(this.primitiveClass)));
        assert (attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ);
        return pbox.get();
    }

    @Override
    public void set(String attributeName, T value) {
        this.rawView.send(attributeName, value);
    }

    @Override
    public boolean exists(String attributeName, AttributeAccess access) {
        return this.rawView.exists(attributeName, access);
    }

    @Override
    public Iterator<ListMapEntryReplication<PrimitiveAttributeReplication<T>>> iterator() {
        return this.rawView.iterator();
    }
}

