package cz.cuni.amis.pogamut.emohawk.bot.impl;

import java.util.Random;

import Steerings.PeopleAvoidanceSteer;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicatedObjectTracker;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Animations;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmohawkNavigation;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Emoticons;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Inventory;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Places;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Steering;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamManager;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004GetBackToNavGraph;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004RunStraight;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetPath;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PathList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class EmohawkBotController<BOT extends UT2004Bot<?,?,?> > extends UT2004BotLogicController<BOT> {

	/**
	 * Random number generator that is usually useful to have during decision making.
	 */
	protected Random random = new Random(System.currentTimeMillis());
	
	/**
	 * Memory module specialized on general info about the game - game type, time limit, frag limit, etc.
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected Game game;
	
	/**
	 * Memory module specialized on general info about the agent whereabouts - location, rotation, health, current weapon, who is enemy/friend, etc.
	 * <p><p>
	 * May be used since first {@link Self} message is received, i.e, since the first {@link IUT2004BotController#botFirstSpawn(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected AgentInfo info;
	
	/**
	 * Memory module specialized on whereabouts of other players - who is visible, enemy / friend, whether bot can see anybody, etc.
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected Players players;
	
	/**
	 * Memory module specialized on agent's senses - whether the bot has been recently killed, collide with level's geometry, etc.
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected Senses senses;
		
	/**
	 * Memory module specialized on the agent's configuration inside UT2004 - name, vision time, manual spawn, cheats (if enabled at GB2004).
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected AgentConfig config;
	
	/**
	 * Support for creating rays used for raycasting (see {@link AutoTraceRay} that is being utilized).
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange, cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage)}
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected Raycasting raycasting;
	
	/**
	 * This allows you to manually steer the movement through the environment.
	 * <p><p>
	 * Note: navigation is done via {@link UT2004BotModuleControllerNew#pathExecutor} that needs {@link PathHandle} from the {@link UT2004BotModuleControllerNew#pathPlanner}.
	 * <p><p>
	 * May be used since since the first {@link IUT2004BotController#botFirstSpawn(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
	 * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
	 */
	protected AdvancedLocomotion move;
	
	/**
	 * Allows you to speak!
	 */
	protected Communication comm;
	
	/**
     * Executor is used for following a path in the environment.
     * <p><p>
     * May be used since since the first {@link IUT2004BotController#botFirstSpawn(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializePathFinding(UT2004Bot)}.
     */
	protected UT2004PathExecutor<ILocated> pathExecutor = null;
	
    /**
     * Planner used to compute the path (consisting of navigation points) inside the map.
     * <p><p>
     * May be used since since the first {@link IUT2004BotController#botFirstSpawn(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage, Self)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializePathFinding(UT2004Bot)}.
     */
    protected IPathPlanner<ILocated> pathPlanner = null;
        
    /**
     * Navigation graph builder that may be used to manually extend the navigation graph of the UT2004.
     * <p><p>
     * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializeModules(UT2004Bot)}.
     */
    protected NavigationGraphBuilder navBuilder;
    
    /**
	 * Navigation helper that is able to get your bot back to the nearest navigation graph so you can use {@link UT2004BotModuleController#navigation} 
	 * without fear of catastrophe.
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializePathFinding(UT2004Bot)}.
	 */
	protected UT2004GetBackToNavGraph getBackToNavGraph;
	
	/**
	 * Navigation helper that can run-straight to some point with stuck detectors.
	 * <p><p>
	 * May be used since {@link IUT2004BotController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage)} 
     * is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializePathFinding(UT2004Bot)}.
	 */
	protected UT2004RunStraight runStraight;
    
    /**
	 * Command module that is internally using {@link UT2004PathExecutor} for path-following and {@link FloydWarshallMap}
	 * for path planning resulting in unified class that can solely handle navigation of the bot within the environment.
	 * <p><p> 
	 * In contrast to {@link UT2004PathExecutor} methods
	 * of this module may be recalled every {@link UT2004BotModuleController#logic()} iteration even with 
	 * the same argument (which is not true for {@link UT2004PathExecutor#followPath(cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture)}.
	 * <p><p>
	 * Note that this class is actually initialized with instances of {@link UT2004BotModuleController#pathExecutor} and {@link UT2004BotModuleController#fwMap}
	 * so you must take care if using add/remove stuck detectors or reinitilize this property to your liking (you can do that in {@link UT2004BotModuleController#botInitialized(cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo, ConfigChange, InitedMessage)} 
	 * method.
	 * <p><p>
	 * May be used since first {@link UT2004BotModuleController#logic()} is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializePathFinding(UT2004Bot)}.
	 */
	protected UT2004Navigation navigation;
    
    /**
     * Listener registrator that probes declared methods for the presence of {@link EventListener}, {@link ObjectClassEventListener},
     * {@link ObjectClassListener}, {@link ObjectEventListener} and {@link ObjectListener} annotations and automatically registers
     * them as listeners on a specific events.
     * <p><p>
     * Note that this registrator is usable for 'this' object only! It will work only for 'this' object.
     */
    protected AnnotationListenerRegistrator listenerRegistrator;
    
    /**
     * Can be used for bot navigation within the environment. 
     * Similar to {@link UT2004Navigation} but uses {@link Steering} with {@link PeopleAvoidanceSteer}.
     * <p><p>
	 * May be used since first {@link UT2004BotModuleController#logic()} is called.
     * <p><p>
     * Initialized inside {@link UT2004BotModuleController#initializePathFinding(UT2004Bot)}.
     */
    protected EmohawkNavigation emohawkNavigation;
        
    /**
     * Shortcut for the {@link UT2004BotModuleController#getWorldView()}.
     */
    protected IVisionWorldView world;
    
    /**
     * Shortcut for the {@link UT2004BotModuleController#getAct()}.
     */
    protected IAct act;
    
    /**
     * Module that is providing various statistics about the bot. You may also used it to output these stats (in CSV format)
     * into some file using {@link AgentStats#startOutput(String)} or {@link AgentStats#startOutput(String, boolean)}.
     */
    protected AgentStats stats;

    /**
     * Path-planner ({@link IPathPlanner} using {@link NavPoint}s), you may use it to find paths inside the environment wihtout
     * waiting for round-trip of {@link GetPath} command and {@link PathList}s response from UT2004. It is much faster than 
     * {@link UT2004BotModuleController#pathPlanner} but you need to pass {@link NavPoint} instances to planner instead of
     * {@link ILocated} ... to find the nearest {@link NavPoint} instance, {@link DistanceUtils} is a handy, check especially
     * {@link DistanceUtils#getNearest(java.util.Collection, ILocated)}.
     */
	protected FloydWarshallMap fwMap;
	
	/**
	 * Module for handling animations.
	 */
	protected Animations animations;
	
	/**
	 * Module for handling emoticons.
	 */
	protected Emoticons emoticons;
	
	/**
	 * High-level description of the map.
	 */
	protected Places places;
	
	/**
	 * High-level access to steering library.
	 */
	protected Steering steering;

	/** High-level access to inventory and items.
	 */
	protected Inventory inventory;
	
	/** Unreal script object replication client
	 */
	protected ObjectReplicationClient objectReplicationClient;
	
	/** Primitive data stream between Unreal and agent  
	 */
	protected StreamManager streamManager;
	
	/** Map of replicated object associations
	 */
	protected IEssenceMap essenceMap;
	
	/** Attribute upstream
	 * 
	 * Uploads attribute changes to server.
	 */
	protected AttributeUpstream attributeUpstream;
	
	/** Action manager
	 *
	 * Initiates actions.
	 */
	protected ActionUpstream actionUpstream;
	
	/** Observation memory
	 */
	protected IObservationMemory observationMemory;
	
    @Override
	public void initializeController(BOT bot) {    	
		super.initializeController(bot);
		world = getWorldView();
		act = getAct();
		initializeModules(bot);
		initializePathFinding(bot);
		initializeListeners(bot);
	}
	
	@Override
	public void finishControllerInitialization() {
//		if (navBuilder.isUsed()) {
//			log.info("Navigation graph has been altered by 'navBuilder', triggering recomputation of Floyd-Warshall path matrix...");
//			Level oldLevel = fwMap.getLog().getLevel();
//			fwMap.getLog().setLevel(Level.FINER);
//			fwMap.refreshPathMatrix();
//			fwMap.getLog().setLevel(oldLevel);
//		}
	}

	public Random getRandom() {
		return random;
	}

	public Game getGame() {
		return game;
	}

	public AgentInfo getInfo() {
		return info;
	}

	public Players getPlayers() {
		return players;
	}

	public Senses getSenses() {
		return senses;
	}
	
	public AgentConfig getConfig() {
		return config;
	}

	public Raycasting getRaycasting() {
		return raycasting;
	}

	public AdvancedLocomotion getMove() {
		return move;
	}
	
	public Communication getComm() {
		return comm;
	}

	public IUnrealPathExecutor<ILocated> getPathExecutor() {
		return pathExecutor;
	}

	public IPathPlanner<ILocated> getPathPlanner() {
		return pathPlanner;
	}

	public IVisionWorldView getWorld() {
		return world;
	}

	public AgentStats getStats() {
		return stats;
	}

	public FloydWarshallMap getFwMap() {
		return fwMap;
	}
	
	public UT2004Navigation getNavigation() {
		return navigation;
	}
	
	/** Get the unreal script replicated object tracker
	 */
	public IReplicatedObjectTracker getReplicatedObjectTracker() {
		return objectReplicationClient;
	}
	
	/** Get the essence map
	 * 
	 * Maps world objects to essences. 
	 */
	public IEssenceMap getEssenceMap() {
		return essenceMap;
	}
	
	/** Get the observation memory
	 * 
	 * Memorizes visible object replications each frame.
	 */
	public IObservationMemory getObservationMemory() {
		return observationMemory;
	}
	
    /**
     * Initializes {@link UT2004BotModuleControllerNew#listenerRegistrator} and calls {@link AnnotationListenerRegistrator#addListeners()} method
     * to probe all declared methods for event-annotation presence.
     * @param bot
     */
	protected void initializeListeners(BOT bot) {
		listenerRegistrator = new AnnotationListenerRegistrator(this, getWorldView(), bot.getLogger().getCategory("Listeners"));
		listenerRegistrator.addListeners();
	}

	/**
	 * Initializes path-finding modules: {@link UT2004BotModuleControllerNew#pathPlanner}, {@link UT2004BotModuleController#fwMap} and {@link UT2004BotModuleControllerNew#pathExecutor}.
	 * If you need different path planner / path executor - override this method and initialize your own modules.
	 * @param bot
	 */
	protected void initializePathFinding(BOT bot) {
		pathPlanner = new UT2004AStarPathPlanner(bot);
		fwMap = new FloydWarshallMap(bot);
		pathExecutor = new UT2004PathExecutor<ILocated>(
       		bot, 
       		new LoqueNavigator<ILocated>(
       			bot, 
       			new KefikRunner(bot, info, move, bot.getLog()), 
       			bot.getLog()
       		)
       	);
		getBackToNavGraph = new UT2004GetBackToNavGraph(bot, info, move);
		runStraight = new UT2004RunStraight(bot, info, move);
		navigation = new UT2004Navigation(bot, pathExecutor, fwMap, getBackToNavGraph, runStraight);
		emohawkNavigation = new EmohawkNavigation(bot, steering, fwMap);
	}

	/**
	 * Initializes observationMemory/command modules of the bot.
	 * 
	 * @param bot
	 */
	protected void initializeModules(BOT bot) {
		assert( this.bot == bot );
		game = makeGame();
		info = makeAgentInfo();
		players = makePlayers();
		senses = makeSenses();
		config = makeAgentConfig();
		raycasting = makeRaycasting();
		move = makeAdvancedLocomotion();
		comm = makeCommunication();
		stats = makeAgentStats();
		navBuilder = makeNavBuilder();
        animations = makeAnimations();
        emoticons = makeEmoticons();
        places = makePlaces();
        steering = makeSteering();
        inventory = makeInventory();
        essenceMap =  makeEssenceMap();
        streamManager = makeStreamManager();
        attributeUpstream = makeAttributeUpstream();
        actionUpstream = makeActionUpstream();
        objectReplicationClient = makeObjectReplicationClient( bot, streamManager );
        objectReplicationClient.registerModule( EssenceMap.class, (EssenceMap) essenceMap );
        objectReplicationClient.registerModule( AttributeUpstream.class, attributeUpstream ); 
        objectReplicationClient.registerModule( ActionUpstream.class, actionUpstream );
        objectReplicationClient.registerModule( IWorldView.class, bot.getWorldView() );
        observationMemory = makeObservationMemory();
	}
	
	// break circular constructor dependency between StreamManager and ObjectReplicationClient
	protected final IReplicatedObjectTracker objectTracker = new IReplicatedObjectTracker() {
		@Override
		public IObjectReplication getObject(int id) {
			return objectReplicationClient.getObject( id );
		}
		@Override
		public boolean exists( int id ) {
			return objectReplicationClient.exists(id);
		}
	};
	
	protected Game makeGame() {
		return new Game(bot);
	}
	
	protected AgentInfo makeAgentInfo() {
		return new AgentInfo(bot, game);
	}
	
	protected Players makePlayers() {
		return  new Players(bot);
	}
	
	protected Senses makeSenses() {
		return new Senses(bot, info, players);
	}
	
	protected AgentConfig makeAgentConfig() {
		return new AgentConfig(bot);
	}
	
	protected Raycasting makeRaycasting() {
		return new Raycasting(bot);
	}
	
	protected AdvancedLocomotion makeAdvancedLocomotion() {
		return new AdvancedLocomotion(getBot(), getBot().getLogger().getCategory("Move"));
	}
	
	protected Communication makeCommunication() {
		return new Communication(getBot(), getBot().getLogger().getCategory("Communicaton"));
	}
	
	protected AgentStats makeAgentStats() {
		return new AgentStats(bot);
	}
	
	protected NavigationGraphBuilder makeNavBuilder() {
		return new NavigationGraphBuilder( bot );
	}
	
	protected Animations makeAnimations() {
		return new Animations(bot);
	}
	
	protected Emoticons makeEmoticons() {
		return new Emoticons(bot);
	}
	
	protected Places makePlaces() {
		return new Places(bot);
	}
	
	protected Steering makeSteering() {
		return new Steering(bot);
	}
	
	protected Inventory makeInventory() {
		return new Inventory(bot);
	}
	
	protected IEssenceMap makeEssenceMap() {
		return new EssenceMap(world);
	} 
	
	protected StreamManager makeStreamManager() {
		return new StreamManager( world, act, objectTracker );
	}
	
	protected AttributeUpstream makeAttributeUpstream() {
		return new AttributeUpstream( bot, streamManager, essenceMap );
	}
	
	protected ActionUpstream makeActionUpstream() {
		return new ActionUpstream( bot.getAct(), world, game, streamManager.getOutputStream(), log );
	}
	
	protected ObjectReplicationClient makeObjectReplicationClient( IUT2004Bot bot, StreamManager streamManager ) {
		return new ObjectReplicationClient( bot, streamManager );
	}
	
	protected IObservationMemory makeObservationMemory() {
		return new ObservationMemory( act, world, essenceMap, info );
	}
}
