package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;

/** Abstract implementation of IObjectReplication
 */
public abstract class AbstractObjectReplication implements IObjectReplication {
	
	/** Object replication client reference
	 *  
	 *  Set when object is replicated.
	 *  Unset when replication is finalized and object is torn-off.
	 */
	protected ObjectReplicationClient objectReplicationClient;
	
	/** Replication id
	 *  
	 *  Replicated object has the same id as the original.
	 */
	protected ReplicationId replicationId;
		
	/** Constructor
	 */
	public AbstractObjectReplication() {
		replicationId = new ReplicationId( -1, 0 );
	}
	
	@Override
	public ReplicationId getReplicationId() {
		return replicationId;
	}
	
	@Override
	public int getReplicationIndex() {
		return replicationId.getIndex();
	}
	
	@Override
	public int getReplicationGenerationNumber() {
		return replicationId.getGenerationNumber();
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId ) {
		objectReplicationClient = initObjectReplicationClient;
		replicationId = initReplicationId;
	}
	
	@Override
	public boolean isLive() {
		return objectReplicationClient != null;
	}
	
	/** Get object replication client
	 */
	public ObjectReplicationClient getObjectReplicationClient() {
		return objectReplicationClient;
	}
	
	@Override
	public void finalizeReplication()	{
		objectReplicationClient = null;
		replicationId = new ReplicationId( -1, 0 );
	}
}