package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** List attribute view
 *  
 * Filters attribute not matching given list type.
 */
public class ListAttributeView<T> implements IListAttributeView<T> {
	
	protected AttributeRawView<ListAttributeReplication<T>,Iterable<T>> rawView;
	protected SpecializedClass<T> primitiveClass;
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ListAttributeView( 
		SpecializedClass<T> primitiveClass, 
		ListMapReplication<IAttributeReplication> attributes,
		AttributeUpstream upstream 
	) {
		this.primitiveClass = primitiveClass;
		rawView = new AttributeRawView<ListAttributeReplication<T>,Iterable<T>>( 
			attributes,
			upstream,
			new SpecializedClass<ListAttributeReplication<T>>( 
				(Class) ListAttributeReplication.class, // java is really dumb here
				Arrays.asList( new SpecializedClass<?>[] { primitiveClass } )
			)
		);
	}
	
	@Override
	public Collection<T> read( String attributeName ) {
		ListAttributeReplication<T> attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		SinglyLinkedListReplication<T> retval = (SinglyLinkedListReplication<T>) attribute.getValue();
		assert( primitiveClass.equals( retval.getValueClass() ) );
		return retval;
	}

	@Override
	public void send( String attributeName, Iterable<T> value ) {
		rawView.send( attributeName, value );
	}

	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplication<ListAttributeReplication<T>>> iterator() {
		return rawView.iterator();
	}
}
