package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist;

import java.util.LinkedList;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AbstractAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAssignableAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;

public class ListAttributeReplication<Element> extends AbstractGenericObjectReplication implements IAssignableAttributeReplication<Iterable<Element>> {

	protected AbstractAttributeReplication<Iterable<Element>> abstractAttribute = new AbstractAttributeReplication<Iterable<Element>>() {
		@Override
		public void serialize(IOutputStream stream, Iterable<Element> value) {
			LinkedList<Element> list = new LinkedList<Element>(); 
			for ( Element element : value ) {
				list.add( element );
			}
			stream.writeInt( list.size() );
			for ( Element element : list ) {
				PrimitiveTools.writePrimitive( element, stream );
			}
		}
	};
	
	public ListAttributeReplication() {
		super(1);
	}
	
	@SuppressWarnings("unchecked")
	public SpecializedClass<Element> getElementType() {
		return (SpecializedClass<Element>) typeParameters[0];
	}
	
	@Override
	public void receive( IInputObjectStream stream) {
		abstractAttribute.receive( stream );
	}

	@Override
	public AttributeAccess getAccess() {
		return abstractAttribute.getAccess();
	}

	@Override
	public int getOwnerControllerId() {
		return abstractAttribute.getOwnerControllerId();
	}

	@Override
	public void serialize(IOutputStream stream, Iterable<Element> value) {
		abstractAttribute.serialize( stream, value );
	}

	@SuppressWarnings("unchecked")
	public SinglyLinkedListReplication<Element> getValue() {
		return (SinglyLinkedListReplication<Element>) abstractAttribute.getValue();
	}
}
