package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;

/** Primitive attribute view
 * 
 * Filters attribute not matching given list type.
 */
public class FoggyRefAttributeView implements IFoggyRefAttributeView {

	protected AttributeRawView<FoggyRefAttributeReplication,IObjectReplication> rawView;
	
	public FoggyRefAttributeView( ListMapReplication<IAttributeReplication> attributes, AttributeUpstream upstream ) {
		rawView = new AttributeRawView<FoggyRefAttributeReplication,IObjectReplication>( 
			attributes,
			upstream,
			SpecializedClass.fromPlain( FoggyRefAttributeReplication.class )
		);
	}
	
	@Override
	public IObjectReplication get( String attributeName ) {
		FoggyRefAttributeReplication attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return attribute.getValue().get();	
	}
	
	@Override
	public boolean isHidden( String attributeName ) {
		FoggyRefAttributeReplication attribute = rawView.getAttributeRecord( attributeName );
		assert( attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ );
		return attribute.getValue().isHidden();	
	}
	
	@Override
	public void set( String attributeName, IObjectReplication value ) {
		rawView.send( attributeName, value );
	}
	
	@Override
	public boolean exists( String attributeName, AttributeAccess access ) {
		return rawView.exists( attributeName, access );
	}
	
	@Override
	public Iterator<ListMapEntryReplication<FoggyRefAttributeReplication>> iterator() {
		return rawView.iterator();
	}
}