package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeManagerReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeManagerReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributedReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Action registry
 */
public class ActionRegistryReplication extends AbstractObjectReplication implements IAttributedReplication {
	
	public static final int ERROR_INVALID_PERFORMER = 1;
	public static final int ERROR_INVALID_ACTION = 2;
	public static final int ERROR_ACCESS_DENIED = 3;
	
	protected AttributeManagerReplication attributes;
	
	@Override
	public IAttributeManagerReplication getAttributes() {
		return attributes;
	}
	
	/** See IObjectReplication
	 */
	public void receive( IInputObjectStream stream )
	{
		// assume only one action definition registry exists
		if ( stream.readBool() ) {
			getObjectReplicationClient().getModule( EssenceMap.class ).associateActionRegistry( this );
		}
		
		attributes = (AttributeManagerReplication) stream.readObjectRef();
	}
}


