package cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;

/** Abstract memorization of an object
 *  
 * @author Paletz
 */
public abstract class AbstractObjectMemorization
	<MemorizedClass extends IObjectReplication>
	implements IObjectMemorization<MemorizedClass> {
	
	protected ObservationMemory observationMemory;
	protected Class<MemorizedClass> objectClass;
	protected double memorizationEpochTime;
	
	public AbstractObjectMemorization( MemorizedClass object, ObservationMemory observationMemory ) {
		super();
		this.observationMemory = observationMemory;
		@SuppressWarnings("unchecked")
		Class<MemorizedClass> tmp = (Class<MemorizedClass>) object.getClass();
		this.objectClass = tmp;
		this.memorizationEpochTime = observationMemory.getEpochTime(); 
	}
	
	@Override
	public Class<MemorizedClass> getReplicationClass() {
		return objectClass;
	}

	@Override
	public double getMemorizationEpochTime() {
		return memorizationEpochTime;
	}
}
