package cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory;

import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.IEssenceMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;

/** Memory of seen entities with associated essences
 * 
 * Memory records are kept until contradicted by observation.
 * TODO track entities without essences?
 * 
 * @author Paletz
 */
public interface IObservationMemory {

	/** Get all sighted essences
	 * 
	 * @return list of all sighted essences
	 */
	List<? extends IEssenceMemorization<?>> getAll();
	
	/** Get all sigted essences of matching memorization class
	 * 
	 * @return list of all sighted essences of matching memorization class
	 */
	<MemorizationClass extends IEssenceMemorization<?>> 
		List<MemorizationClass> 
		getAllByMemorization( Class<? extends MemorizationClass> memorizationClass );
	
	/** Set memory record importance
	 * 
	 * Important records are more often checked for contradicting observations.
	 * Default importance value is 1.0.
	 * 
	 * @param memorizedEssence memory record, must be a currently memorized nonethereal essence
	 * @param importance importance value, must be a positive number
	 */
	void setImportance( IEssenceMemorization<?> memorizedEssence, double importance );
	
	/** Contradict a sighting
	 * 
	 * Remove sighting from memory due to contradiction.
	 * 
	 * @param sighting sighting to remove
	 */
	void contradict(IEssenceMemorization<?> sighting);
	
	/** Get memorization of an observed object
	 * 
	 * Uses cache to handle circular references.
	 * 
	 * @param object observed object
	 * @return memorization of the object
	 */
	<MemorizedClass extends IObjectReplication> IObjectMemorization<MemorizedClass> getMemorization(MemorizedClass object);
	
	/** Get preimage of fresh memorization
	 * 
	 * Reverse of getMemorization().
	 * 
	 * @param freshMemorization memorization, must be fresh ( memorization epoch time == epoch time )
	 * @return preimage of the memorization
	 */
	<MemorizedClass extends IObjectReplication> MemorizedClass getPreimage( IObjectMemorization<MemorizedClass> freshMemorization );

	/** Get epoch time
	 * 
	 * @return epoch time
	 */
	double getEpochTime();
}
