package cz.cuni.amis.pogamut.emohawk.agent.module.essence;

import java.util.Map;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ControllerInfoReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.IEssenceReplication;

/** Essence association map interface
 * 
 * Associates world object essence with its world object.
 * 
 * @author Paletz
 */
public interface IEssenceMap {
	
	/** Retrieve Pawn object associated with given bot ID if such exists
	 * 
	 * @param botId bot ID
	 * @return Pawn object associated with given bot ID if such exists, null otherwise
	 */
	PawnReplication retrievePawn( String botId );
	
	/** Retrieve Pawn object associated with given world object if such exists
	 * 
	 * @param worldObject world object
	 * @return Pawn object associated with given world object if such exists, null otherwise
	 */
	PawnReplication retrievePawn( IWorldObject worldObject );
	
	/** Retrieve Controller object associated with given bot ID if such exists
	 * 
	 * @param botId bot ID
	 * @return Controller object associated with given bot ID if such exists, null otherwise
	 */
	ControllerInfoReplication retrieveController( String botId );
	
	/** Retrieve Controller object associated with given world object if such exists
	 * 
	 * @param worldObject world object
	 * @return Controller object associated with given world object if such exists, null otherwise
	 */
	ControllerInfoReplication retrieveController( IWorldObject worldObject );
		
	/** Retrive action registry
	 *
	 * @return action registry
	 */
	ActionRegistryReplication retrieveActionRegistry();
		
	/** Retrieve Essence object associated with given world object ID if such exists
	 */
	IEssenceReplication retrieveEssence( String worldObjectId );
	
	/** Retrieve Essence object associated with given entity if such exists
	 */
	IEssenceReplication retrieveEssence( IWorldObject entity );
	
	/** Get map of all visible essences
	 * 
	 * Essence is visible if it is associated with a visible world object.
	 * 
	 * @param essenceClass essenceClass to filter
	 * @return map world object -> essence
	 */
	<Essence extends IEssenceReplication> Map<IWorldObject,Essence> getAllVisible( Class<Essence> essenceClass );
}
