/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicatedObjectTracker;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.ObjectStreamBuffer;
import cz.cuni.amis.pogamut.emohawk.communication.stream.BoolPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.BoolPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.DataPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.FloatPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.FloatPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IntPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IntPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.ObjectRefPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StringPacketCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StringPacketInfoMessage;

public class StreamManager {
    protected IWorldView world;
    protected IAct act;
    protected IReplicatedObjectTracker objectTracker;
    protected ObjectStreamBuffer inputBuffer;
    protected IWorldEventListener<DataPacketInfoMessage<?>> dataListener = new IWorldEventListener<DataPacketInfoMessage<?>>(){

        public void notify(DataPacketInfoMessage<?> event) {
            if (event instanceof IntPacketInfoMessage) {
                StreamManager.this.inputBuffer.writeInt((Integer)((IntPacketInfoMessage)event).getValue());
            } else if (event instanceof FloatPacketInfoMessage) {
                StreamManager.this.inputBuffer.writeFloat(((Float)((FloatPacketInfoMessage)event).getValue()).floatValue());
            } else if (event instanceof BoolPacketInfoMessage) {
                StreamManager.this.inputBuffer.writeBool((Boolean)((BoolPacketInfoMessage)event).getValue());
            } else if (event instanceof StringPacketInfoMessage) {
                StreamManager.this.inputBuffer.writeString((String)((StringPacketInfoMessage)event).getValue());
            } else if (event instanceof ObjectRefPacketInfoMessage) {
                ObjectRefPacketInfoMessage refPacket = (ObjectRefPacketInfoMessage)event;
                if ((Integer)refPacket.getValue() != -1) {
                    StreamManager.this.inputBuffer.writeObjectRef(StreamManager.this.objectTracker.getObject((Integer)refPacket.getValue()));
                } else {
                    StreamManager.this.inputBuffer.writeObjectRef(null);
                }
            } else {
                throw new RuntimeException("Unexpected DataPacket class " + ((Object)event).getClass());
            }
        }
    };
    protected IOutputStream upstream = new IOutputStream(){

        @Override
        public void writeString(String value) {
            StringPacketCommand packet = new StringPacketCommand();
            packet.setValue(value);
            StreamManager.this.act.act((CommandMessage)packet);
        }

        @Override
        public void writeInt(int value) {
            IntPacketCommand packet = new IntPacketCommand();
            packet.setValue(value);
            StreamManager.this.act.act((CommandMessage)packet);
        }

        @Override
        public void writeFloat(float value) {
            FloatPacketCommand packet = new FloatPacketCommand();
            packet.setValue(Float.valueOf(value));
            StreamManager.this.act.act((CommandMessage)packet);
        }

        @Override
        public void writeBool(boolean value) {
            BoolPacketCommand packet = new BoolPacketCommand();
            packet.setValue(value);
            StreamManager.this.act.act((CommandMessage)packet);
        }
    };

    public StreamManager(IWorldView world, IAct act, IReplicatedObjectTracker objectTracker) {
        this.act = act;
        this.world = world;
        this.objectTracker = objectTracker;
        this.inputBuffer = new ObjectStreamBuffer();
        world.addEventListener(DataPacketInfoMessage.class, this.dataListener);
    }

    public IInputObjectStream getInputStream() {
        return this.inputBuffer;
    }

    public void clearInput() {
        this.inputBuffer.clear();
    }

    public IOutputStream getOutputStream() {
        return this.upstream;
    }
}

