package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;

/** Data packet info message.
 * 
 * Abstract base of all data packet info messages.
 *  
 * @author Paletz
 * 
 * @param <T> type of value in the packet
 */
public abstract class DataPacketInfoMessage<T> extends InfoMessage implements IWorldEvent, IWorldChangeEvent  {	

	protected long simTime;
	protected T value;
	
	public DataPacketInfoMessage() {
		simTime = 0;
	}	
	
	/** Initialization from yylex
	 */
	public void setSimTime( long value ) {
		simTime = value;
	}

	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime()
	{
		return simTime;
	}

	/** Initialization from yylex
	 */
	public void setValue( T value ) {
		this.value = value;
	}

	/** Get the value
	 * 
	 * @return the value	 
	 */
	public T getValue() {
		return value;
	}
}
