package cz.cuni.amis.pogamut.emohawk.agent.module.stream;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;

/** Serialization tools
 * 
 * NOTE: Keep serialization format in sync with unreal script (Emohawk/EhSerializationTools).
 * 
 * @author Paletz
 */
public class SerializationTools {
	
	/** Serialize replication ID
	 * 
	 * @param stream stream to serialize to
	 * @param replicationId replication ID to serialize
	 */
	public static void serializeReplicationId( IOutputStream stream, ReplicationId replicationId ) {
		stream.writeInt( replicationId.getIndex() );
		stream.writeInt( replicationId.getGenerationNumber() );
	}

	/** Deserialize replication id
	 * 
	 * @param stream stream to deserialize from
	 * @return replication ID if successful, null otherwise
	 */
	public static ReplicationId deserializeReplicationId( IInputStream stream ) {
		int index, generationNumber;
		if ( stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT )
		{
			return null;
		}
		index = stream.readInt();
		if ( stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT )
		{
			return null;
		}
		generationNumber = stream.readInt();
		
		return new ReplicationId( index, generationNumber );
	}
	

	/** Serialize object reference on client-side
	 *  
	 * @param stream stream to serialize to
	 * @param objectReference reference to serialize
	 */
	public static void serializeObjectReferenceOnClient( IOutputStream stream, IObjectReplication objectReference )
	{
		if ( objectReference == null )
		{
			stream.writeInt( -1 );
			stream.writeInt( 0 );
		}
		else
		{
			assert( objectReference.isLive() );
			serializeReplicationId( stream, objectReference.getReplicationId() );
		}
	}
	
	/** Serialize location
	 * 
	 * Unreal script equivalent is Vector.
	 * Accuracy is reduced to float.
	 * 
	 * @param stream stream to serialize to
	 * @param location location to serialize
	 */
	public static void serializeLocation( IOutputStream stream, Location location )
	{
		stream.writeFloat( (float) location.getX() );
		stream.writeFloat( (float) location.getY() );
		stream.writeFloat( (float) location.getZ() );
	}
	
	/** Deserialize location
	 * 
	 * Unreal script equivalent is Vector.
	 * Actual accuracy is float.
	 * 
	 * @param stream stream to deserialize from
	 * @return deserialized location or null
	 */
	public static Location deserializeVector( IInputStream stream )
	{
		float x,y,z;

		if ( stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT )
		{
			return null;
		}
		x = stream.readFloat();

		if ( stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT )
		{
			return null;
		}
		y = stream.readFloat();

		if ( stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT )
		{
			return null;
		}	
		z = stream.readFloat();

		return new Location( x, y, z );
	}
}
