package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Node of a singly-linked list.
*
*/
public class SinglyLinkedListNodeReplication<Element> extends AbstractGenericObjectReplication {
	
	protected Element value;
	protected SinglyLinkedListNodeReplication<Element> next;
	
	public SinglyLinkedListNodeReplication() {
		super( 1 );
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings("unchecked")
	public SpecializedClass<Element> getValueClass()	{
		return (SpecializedClass<Element>) typeParameters[0];
	}

	/** Get stored value
	 */ 
	public Element getValue() {
		return value;
	}
	
	/** Get next node
	 */
	public SinglyLinkedListNodeReplication<Element> getNext() {
		return next;
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicableObject#receive(cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream)
	 */
	@SuppressWarnings("unchecked")
	public void receive( IInputObjectStream inputStream )	{
		value = (Element) PrimitiveTools.readPrimitive( getValueClass().getGenericClass(), inputStream );
		next = (SinglyLinkedListNodeReplication<Element>) inputStream.readObjectRef();
		assert( next == null || next.getValueClass().equals( getValueClass() ) );
	}
}
