package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import java.util.Arrays;
import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** A map backed-up by a list
*
* Keys are strings.
*/
public class ListMapReplication<ValueType> extends AbstractGenericObjectReplication implements Iterable<ListMapEntryReplication<ValueType>> {
	
	protected SinglyLinkedListReplication<ListMapEntryReplication<ValueType>> list;
		
	public ListMapReplication() {
		super(1);
	}
	
	/** Get value type parameter class
	 * 
	 * @return value type parameter class
	 */
	@SuppressWarnings("unchecked")
	public SpecializedClass<ValueType> getValueClass() {
		return (SpecializedClass<ValueType>) typeParameters[0];
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Iterable#iterator()
	 */
	public Iterator<ListMapEntryReplication<ValueType>> iterator()
	{
		return list.iterator();
	}
	
	
	/** Get entry count
	 * 
	 * @return entry count
	 */
	public int size() {
		return list.size();
	}

	/** Tell if map is empty
	 * 
	 * @return true if map is empty
	 */
	public boolean isEmpty() {
		return size() == 0;
	}

	/** Tell if mapping exists for a key
	 *
	 * @param key key
	 * @return true if mapping exists for the key
	 */
	public boolean containsKey(String key) {
		return findEntry( (String) key ) != null;
	}

	public boolean containsValue(ValueType value) {
		for ( ListMapEntryReplication<ValueType> entry : list ) {
			if ( entry.getValue().equals( value ) ) {
				return true;
			}
		}
		return false;
	}
	
	/** Get value of mapped to key
	 *
	 * @param key key, mapping must be defined for the key
	 * @return value mapped to key
	 */
	public ValueType get(String key) {
		ListMapEntryReplication<ValueType> entry = findEntry( (String) key );
		
		if ( entry == null ) {
			return null;
		}
			
		return entry.getValue();
	}
	
	/** see EhIReplicableObject
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void receive( IInputObjectStream inputStream) {
		list =  (SinglyLinkedListReplication<ListMapEntryReplication<ValueType>>) inputStream.readObjectRef();
		assert( list.getValueClass().equals( getEntryClass() ) );
	}
	
	protected ListMapEntryReplication<ValueType> findEntry( String key )
	{
		for ( ListMapEntryReplication<ValueType> entry : list ) {
			if ( entry.getKey().equals( key ) )	{
				return entry;
			}
		}
		return null;
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected SpecializedClass<ListMapEntryReplication<ValueType>> getEntryClass() {
		return new SpecializedClass<ListMapEntryReplication<ValueType>>(
			(Class) ListMapEntryReplication.class,
			Arrays.asList( new SpecializedClass<?>[] { getValueClass() } )
		);
	}
}