package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

public class FoggyRefReplication extends AbstractObjectReplication {
	
	protected int referenceIndex;
	
	public FoggyRefReplication() {
		super();
	}
	
	/** Get referenced value
	 * 
	 * It is an error to get() hidden reference on client-side.
	 * 
	 * @return referenced object
	 */
	public IObjectReplication get()
	{
		if ( referenceIndex == -1 )
		{
			return null;
		}
		else
		{
			assert( objectReplicationClient.exists( referenceIndex ) );
			return objectReplicationClient.getObject( referenceIndex );
		}
	}

	/** Tell if referenced object is hidden
	 *  
	 * @return false if reference is null or the referenced object is replicated, true if the referenced object is not replicated
	 */
	public boolean isHidden()
	{
		return referenceIndex != -1 && !objectReplicationClient.exists( referenceIndex );
	}
	
	@Override
	public void receive( IInputObjectStream stream ) {
		referenceIndex = stream.readInt();
	}
}
