package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AbstractAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAssignableAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveBoxReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractGenericObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IOutputStream;

public class PrimitiveAttributeReplication<Primitive> extends AbstractGenericObjectReplication implements IAssignableAttributeReplication<Primitive> {

	protected AbstractAttributeReplication<Primitive> abstractAttribute = new AbstractAttributeReplication<Primitive>() {
		@Override
		public void serialize(IOutputStream stream, Primitive value) {
			PrimitiveTools.writePrimitive( value, stream );
		}
	};
	
	@SuppressWarnings("unchecked")
	public PrimitiveBoxReplication<Primitive> getValue() {
		return (PrimitiveBoxReplication<Primitive>) abstractAttribute.getValue();
	}
	
	public PrimitiveAttributeReplication() {
		super(1);
	}
	
	@SuppressWarnings("unchecked")
	public SpecializedClass<Primitive> getElementType() {
		return (SpecializedClass<Primitive>) typeParameters[0];
	}
	
	@Override
	public void receive( IInputObjectStream stream) {
		abstractAttribute.receive( stream );
	}

	@Override
	public AttributeAccess getAccess() {
		return abstractAttribute.getAccess();
	}

	@Override
	public int getOwnerControllerId() {
		return abstractAttribute.getOwnerControllerId();
	}

	@Override
	public void serialize(IOutputStream stream, Primitive value) {
		abstractAttribute.serialize( stream, value );
	}
}