package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute;

import java.util.Iterator;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref.FoggyRefAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref.IFoggyRefAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist.FoggyRefListAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist.IFoggyRefListAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.PrimitiveAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist.ListAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Attribute manager
 *  
 * Manages attributes of various types.
 * Attribute name must be unique among all attribute types.
 */
public class AttributeManagerReplication extends AbstractObjectReplication implements IAttributeManagerReplication {
	
	protected ListMapReplication<IAttributeReplication> attributes;
	protected AttributeUpstream upstream;
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public PrimitiveAttributeView<Integer> ints() {
		return new PrimitiveAttributeView<Integer>( Integer.class, attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */

	public PrimitiveAttributeView<Float> floats() {
		return new PrimitiveAttributeView<Float>( Float.class, attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public PrimitiveAttributeView<Boolean> bools() {
		return new PrimitiveAttributeView<Boolean>( Boolean.class, attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public PrimitiveAttributeView<String> strings() {
		return new PrimitiveAttributeView<String>( String.class, attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public IFoggyRefAttributeView refs() {
		return new FoggyRefAttributeView( attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public ListAttributeView<Integer> intLists() {
		return new ListAttributeView<Integer>( SpecializedClass.fromPlain( Integer.class ), attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public ListAttributeView<Float> floatLists() {
		return new ListAttributeView<Float>( SpecializedClass.fromPlain( Float.class ), attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public ListAttributeView<Boolean> boolLists() {
		return new ListAttributeView<Boolean>( SpecializedClass.fromPlain( Boolean.class ), attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public ListAttributeView<String> stringLists() {
		return new ListAttributeView<String>( SpecializedClass.fromPlain( String.class ), attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	public IFoggyRefListAttributeView refLists() {
		return new FoggyRefListAttributeView( attributes, upstream );
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.IAttributeManager#ints()
	 */
	@Override
	public Iterator<ListMapEntryReplication<IAttributeReplication>> iterator() {
		return attributes.iterator();
	}
	
	/* (non-Javadoc)
	 * @see cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicableObject#receive(cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputStream)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void receive( IInputObjectStream inputStream )	{
		attributes = (ListMapReplication<IAttributeReplication>) inputStream.readObjectRef();
		assert( attributes.getValueClass().equals( SpecializedClass.fromPlain( IAttributeReplication.class ) ) );
		upstream = objectReplicationClient.getModule( AttributeUpstream.class );
	}
}