package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Attribute record
 * 
 * @author Paletz
 */
public abstract class AbstractAttributeReplication<IntermediateValue> extends AbstractObjectReplication implements IAssignableAttributeReplication<IntermediateValue> {
	
	protected AttributeAccess access;
	protected int ownerControllerId;
	protected IObjectReplication value; 
	
	/** Get access flag
	 * 
	 * @return access flag
	 */
	public AttributeAccess getAccess()
	{
		return access;
	}
	
	/** Get the value
	 *
	 * @return the value
	 */
	public IObjectReplication getValue()
	{
		return value;
	}
	
	/** Get owner controller id
	 *  
	 * @return owner controller ID or special constant OWNER_COMMUNITY or OWNER_NA
	 */
	public int getOwnerControllerId()
	{
		return ownerControllerId;
	}
	
	@Override
	public void receive( IInputObjectStream stream )
	{
		access = AttributeAccess.values()[stream.readInt()];
		ownerControllerId = stream.readInt();
		if ( access == AttributeAccess.ATTRIBUTE_ACCESS_READ )
		{
			value = stream.readObjectRef();
		}
	}
}