package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.AbstractObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;

/** Human player or AI agent controller info
 * 
 */
public class ControllerInfoReplication extends AbstractObjectReplication{
	protected int controllerId;
	
	/** Get controller ID
	 *  
	 * Controller ID is unique even in respect to past and future controllers. It is a constant natural number.
	 * @return controller ID
	 */
	public int getControllerId() {
		return controllerId;
	}
	
	@Override
	public void receive( IInputObjectStream inputStream) {
		controllerId = inputStream.readInt();
		String botId = inputStream.readString();
		assert( !botId.isEmpty() );
		objectReplicationClient.getModule( EssenceMap.class ).associateController( botId, this );
	}
}
