package cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplication;

/** Foggy reference memorization
 * 
 * @author Paletz
 * 
 * @param <Memorization>
 */
public class FoggyRefMemorization
	<Memorization extends IObjectMemorization<?>> {
	
	protected boolean isHidden;
	protected Memorization ref;
	
	public FoggyRefMemorization( boolean isHidden, Memorization ref ) {
		this.isHidden = isHidden;
		this.ref = ref;
	}
	
	public static <Memorization extends IObjectMemorization<?>> FoggyRefMemorization<Memorization> make( 
		boolean isHidden, 
		Memorization ref 
	) {
		return new FoggyRefMemorization<Memorization>( isHidden, ref );
	}
	
	public static <Memorization extends IObjectMemorization<?>>	FoggyRefMemorization<Memorization> make( 
		FoggyRefReplication foggyRefReplication,
		ObservationMemory observationMemory,
		Class<Memorization> memorizationClass 
	) {
		Memorization ref = null;
		if ( !foggyRefReplication.isHidden() ) {
			@SuppressWarnings("unchecked")
			Memorization tmp = (Memorization) observationMemory.getMemorization( foggyRefReplication.get() );
			ref = tmp;
		}
		
		return new FoggyRefMemorization<Memorization>( foggyRefReplication.isHidden(), ref );
	};
		
	public boolean isHidden() {
		return isHidden;
	}
	
	public Memorization get() {
		assert( !isHidden );
		return ref;
	}
}
