package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container;

import java.util.Collection;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributedReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;

/** Possessor implementation component
 */
public class PossessorComponent {
	
	public static final String INVENTORY_ATTR = "inventory";
	
	protected IAttributedReplica attributeProvider;
	protected IPossessorReplica parent;
		
	public PossessorComponent(IAttributedReplica attributeProvider, IPossessorReplica parent) {
		super();
		assert( attributeProvider != null && parent != null );
		this.attributeProvider = attributeProvider;
		this.parent = parent;
	}
	
	/** See IPossessor
	 */
	public Collection<? extends IItemReplica> readInventory()
	{
		return Collections2.transform( 
			attributeProvider.getAttributes().refLists().read( INVENTORY_ATTR ),
			new Function<FoggyRefReplica,IItemReplica>() {
				@Override
				public IItemReplica apply( FoggyRefReplica arg ) {
					return (IItemReplica) arg.get();
				}
			}
		); 
	}
}