package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.container;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;

/** Take item from container action
 */
public class TakeItemFromContainerActionReplica extends AbstractContainerActionReplica implements IActionReplica {
		
	public static final int ERROR_TAKEN_ITEM_NOT_IN_CONTAINER = 16;
	public static final int ERROR_COLLECTOR_DENIED = 17;
	public static final int ERROR_CONTAINER_DENIED = 18;
	
	/** Constructor
	 */
	public TakeItemFromContainerActionReplica() {
	}
	
	@Override
	public String getActionName() {
		return "Take item from container";
	}
	
	/** Request action
	 *  
	 * @param performer action performer
	 * @param container container to take the item from
	 * @param takenItem item to take, must be in container's inventory
	 * @param resultHandler result handler
	 */
	public void request( ICollectorReplica performer, IContainerReplica container, IItemReplica takenItem, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, container );
		SerializationTools.serializeObjectReferenceOnClient( arguments, takenItem );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}