package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.container;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollector;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;

/** Container actions
 * 
 * Common functionality of store and take item actions.
 */
public abstract class AbstractContainerActionReplica extends AbstractActionReplica {
	
	public static final int ERROR_CONTAINER_INVALID = 10;
	public static final int ERROR_ITEM_INVALID = 11;
	public static final int ERROR_PERFORMER_NOT_COLLECTOR = 12;
	public static final int ERROR_CONTAINER_OUT_OF_REACH = 15;

	public static final float DEFAULT_RANGE = 100.0f;
	
	protected static final String RANGE_ATTR = "range";
	
	/** Constructor
	 */
	public AbstractContainerActionReplica() {
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Tell if the collector can reach the container
	 */
	public boolean canReach( ICollector collector, IContainer container, double rangeMultiplier )
	{
		return (
			EssenceDistanceTools.computeDistanceOfEssences( collector, container )
			<=
			getRange()*rangeMultiplier
		);
	}
}