package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;


/** Drop an item from the inventory action at given location
 *  
 * The location must be in line of sight and world geometry must support the item from below. Inherent inaccuracy is corrected on server-side. 
 * If location is ommitted the point where the performer stands is used with the same limitations.
 */
public class DropItemActionReplica extends AbstractActionReplica {
	
	public static final int ERROR_COLLECTOR_DENIED = 10;
	public static final int ERROR_TARGET_INVALID = 11;
	public static final int ERROR_TARGET_NOT_IN_INVENTORY = 12;
	public static final int ERROR_PERFORMER_NOT_COLLECTOR = 13;
	public static final int ERROR_LOCATION_INVALID = 14;
	public static final int ERROR_LOCATION_OUT_OF_LOS = 15;
	public static final int ERROR_LOCATION_IN_AIR = 16;
	public static final int ERROR_LOCATION_OUT_OF_RANGE = 17;

	public static final float DEFAULT_RANGE = 200.0f;
	public static final float DEFAULT_MAX_VERTICAL_ADJUSTMENT = 10.0f;
	
	protected static final String RANGE_ATTR = "range";
	protected static final String MAX_VERTICAL_ADJUSTMENT_ATTR = "maxVerticalAdjustment";
		
	/** Constructor
	 */
	public DropItemActionReplica() {
	}
	
	@Override
	public String getActionName() {
		return "Drop item";
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
		
	/** Get max vertical adjustment
	 */
	public float getMaxVerticalAdjustment() {
		return attributes.floats().get( MAX_VERTICAL_ADJUSTMENT_ATTR );
	}
		
	/** Tell if the collector can drop an item at the location
	 */
	public boolean canReach( ICollector collector, Location location, float rangeMultiplier )
	{
		return ( 
			EssenceDistanceTools.computeDistanceOfEssenceToLocation( collector, location ) 
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Request to drop at current collector location
	 *  
	 * @param performer action performer
	 * @param item item to drop
	 * @param resultHandler result handler
	 */
	public void requestDrop( ICollectorReplica performer, IItemReplica item, IActionResultHandler resultHandler )	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, item );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
	
	/** Request to drop item at specified location
	 *  
	 * @param performer action performer
	 * @param item item to drop
	 * @param location where to drop the item
	 * @param resultHandler result handler
	 */
	public void requestDropAt( ICollectorReplica performer, IItemReplica item, Location location, IActionResultHandler resultHandler ) {
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, item );
		SerializationTools.serializeLocation( arguments, location );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
}