package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.action.trade;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.ds.FoggyRefMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.process.AbstractProcessMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.IBartererReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.ITradeProcess;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.TradeProcessReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;

public class TradeProcessMemorization 
	extends AbstractProcessMemorization<TradeProcessReplica>
	implements ITradeProcess {
	
	protected FoggyRefMemorization<IBartererMemorization<IBartererReplica>> barterPartner;
	protected List<IItemMemorization<IItemReplica>> offer;
	protected boolean hasAccepted;
	protected float lastOfferChangeTime;
	
	public TradeProcessMemorization(
		final TradeProcessReplica object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor( 
			new IDeferredConstructor() {
				@Override
				public void construct() {
					if ( ! object.isBarterPartnerHidden() ) {
						barterPartner = FoggyRefMemorization.make( 
							false, 
							(IBartererMemorization<IBartererReplica>) observationMemory.getMemorization( object.getBarterPartner() ) 
						);
					} else {
						barterPartner = FoggyRefMemorization.make( true, null );
					}
					offer = new LinkedList<IItemMemorization<IItemReplica>>();
					for ( IItemReplica item : object.readOffer() ) {
						offer.add( (IItemMemorization<IItemReplica>) observationMemory.getMemorization( item ) );
					}
					hasAccepted = object.hasAccepted();
					lastOfferChangeTime = object.getLastOfferChangeTime();
				}
			}
		);
	}
	
	@Override
	public boolean isBarterPartnerHidden() {
		return barterPartner.isHidden();
	}
	
	@Override
	public IBartererMemorization<IBartererReplica> getBarterPartner() {
		return barterPartner.get();
	}

	@Override
	public TradeProcessMemorization getBarterPartnerProcess() {
		if ( !isBarterPartnerHidden() && getBarterPartner() != null ) {
			return (TradeProcessMemorization) getBarterPartner().getProcess();
		} else {
			return null;
		}
	}

	@Override
	public boolean isEstablished() {
		return getBarterPartnerProcess() != null;
	}

	@Override
	public boolean hasAccepted() {
		return hasAccepted;
	}
	
	@Override
	public Iterable<? extends IItemMemorization<IItemReplica>> readOffer() {
		return Collections.unmodifiableList( offer );
	}
	
	@Override
	public float getLastOfferChangeTime() {
		return lastOfferChangeTime;
	}
}
