package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container;

import java.util.Collection;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributedReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;

/** Warehouse implementation component
 */
public class WarehouseComponent {
	
	public static final String INVENTORY_ATTR = "inventory";
	
	protected IAttributedReplication attributeProvider;
	protected IWarehouseReplication parent;
		
	public WarehouseComponent(IAttributedReplication attributeProvider, IWarehouseReplication parent) {
		super();
		assert( attributeProvider != null && parent != null );
		this.attributeProvider = attributeProvider;
		this.parent = parent;
	}
	
	/** See IWarehouse
	 */
	public Collection<? extends IItemReplication> readInventory()
	{
		return Collections2.transform( 
			attributeProvider.getAttributes().refLists().read( INVENTORY_ATTR ),
			new Function<FoggyRefReplication,IItemReplication>() {
				@Override
				public IItemReplication apply( FoggyRefReplication arg ) {
					return (IItemReplication) arg.get();
				}
			}
		); 
	}
}