package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade;

import java.util.Collection;
import java.util.Iterator;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.IInputObjectStream;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.AbstractProcessReplication;

/** Process of trading
 * 
 * @author Paletz
 */
public class TradeProcessReplication extends AbstractProcessReplication implements ITradeProcess {

	public static final String BARTER_PARTNER_ATTR = "barterPartner";
	public static final String HAS_ACCEPTED_ATTR = "hasAccepted";
	public static final String OFFER_ATTR = "offer";
	public static final String OFFER_IN_ATTR = "offer_in";
	public static final String HAS_ACCEPTED_IN_ATTR = "hasAccepted_in";
	public static final String LAST_OFFER_CHANGE_TIME_ATTR = "lastOfferChangeTime";
	
	@Override
	public boolean isBarterPartnerHidden() {
		return attributes.refs().isHidden( BARTER_PARTNER_ATTR );
	}
	
	@Override
	public IBartererReplication getBarterPartner() {
		return (IBartererReplication) attributes.refs().get( BARTER_PARTNER_ATTR );
	}

	@Override
	public TradeProcessReplication getBarterPartnerProcess() {
		if ( !isBarterPartnerHidden() && getBarterPartner() != null ) {
			return (TradeProcessReplication) getBarterPartner().getProcess();
		} else {
			return null;
		}
	}

	@Override
	public boolean isEstablished() {
		return getBarterPartnerProcess() != null;
	}

	@Override
	public boolean hasAccepted() {
		return attributes.bools().get( HAS_ACCEPTED_ATTR );
	}

	@Override
	public Collection<? extends IItemReplication> readOffer()
	{
		return Collections2.transform( 
			attributes.refLists().read( OFFER_ATTR ),
			new Function<FoggyRefReplication,IItemReplication>() {
				@Override
				public IItemReplication apply( FoggyRefReplication arg ) {
					return (IItemReplication) arg.get();
				}
			}
		);
	}
	
	/** Send offer
	 * 
	 * @param offered items
	 */
	public void sendOffer( Iterable<IItemReplication> offer ) {
		final Iterable<IItemReplication> finalOffer = offer;
		getAttributes().refLists().send( 
			OFFER_IN_ATTR,
			new Iterable<IObjectReplication>() {
				@Override
				public Iterator<IObjectReplication> iterator() {
					final Iterator<IItemReplication> underlyingIterator = finalOffer.iterator();
					return new Iterator<IObjectReplication>() {
						@Override
						public boolean hasNext() {
							return underlyingIterator.hasNext();
						}

						@Override
						public IObjectReplication next() {
							return (IObjectReplication) underlyingIterator.next();
						}

						@Override
						public void remove() {
						}
					};
				}
			}
		);
	}

	/** Send if local side accepts offer
	 */
	public void sendHasAccepted( boolean value ) {
		attributes.bools().set( HAS_ACCEPTED_IN_ATTR, value );
	}
	
	@Override
	public float getLastOfferChangeTime() {
		return attributes.floats().get( LAST_OFFER_CHANGE_TIME_ATTR );
	}
	
	@Override
	public void receive( IInputObjectStream stream) {
		super.receive( stream );
	}
}
