package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItemReplication;

/** Merge two items.
 *  
 * Merges two items. Dissolved item's content is added to merged item's content. Execution performer must be the ownerWarehouse containig both items.
 */
public class MergeItemActionReplication extends AbstractActionReplication {
	
	public static final int ERROR_PERFORMER_NOT_COLLECTOR = 10;
	public static final int ERROR_MERGED_ITEM_ARGUMENT_INVALID = 11;
	public static final int ERROR_DISSOLVED_ITEM_ARGUMENT_INVALID = 12;
	public static final int ERROR_INCOMPATIBLE_ITEMS = 13;
	public static final int ERROR_COLLECTOR_DENIED = 14;
	
	
	/** Constructor
	 */
	public MergeItemActionReplication() {
	}
	
	@Override
	public String getActionName() {
		return "Merge item";
	}
		
	/** Request
	 * 
	 * Client-side only.
	 * 
	 * @param performer action performer
	 * @param mergedItem item to merge
	 * @param dissolvedItem item to dissolve
	 * @param resultHandler result handler
	 */ 
	public void request( ICollectorReplication performer, IMergeableItemReplication mergedItem, IMergeableItemReplication dissolvedItem, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, mergedItem );
		SerializationTools.serializeObjectReferenceOnClient( arguments, dissolvedItem );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}