package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.SemifinishedMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.PawnMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.action.trade.TradeProcessMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.TradeProcessReplication;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;

public class ObservationMemory extends  cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.ObservationMemory {

	public ObservationMemory(
		IAct act, 
		IVisionWorldView worldView,
		IEssenceMap essenceMap, 
		AgentInfo agentInfo
	) {
		super(act, worldView, essenceMap, agentInfo);
	}
	
	@Override
	protected SemifinishedMemorization makeMemorization( IObjectReplication object ) {
		SemifinishedMemorization retval = new SemifinishedMemorization();
		if ( object instanceof TradeProcessReplication ) {
			retval.memorization = new TradeProcessMemorization( (TradeProcessReplication) object, this, retval );
			return retval;
		}
		if ( object instanceof PawnReplication ) {
			retval.memorization = new PawnMemorization<PawnReplication>( (PawnReplication) object, this, retval );
			return retval;
		}
		return super.makeMemorization(object);
	}
}
