package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.ActionRegistryReplication;

/** Association map interface
 * 
 * @author Paletz
 */
public interface IEssenceMap extends cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap {
	
	/** Retrieve PawnReplication object associated with given bot ID if such exists
	 * 
	 * @param botId bot ID
	 * @return PawnReplication object associated with given bot ID if such exists, null otherwise
	 */
	PawnReplication retrievePawn( String botId );
	
	/** Retrieve PawnReplication object associated with given world object if such exists
	 * 
	 * @param worldObject world object
	 * @return PawnReplication object associated with given world object if such exists, null otherwise
	 */
	PawnReplication retrievePawn( IWorldObject worldObject );
	
	/** Retrive action registry
	 *
	 * @return action registry
	 */
	ActionRegistryReplication retrieveActionRegistry();
}
