package cz.cuni.amis.pogamut.defcon.consts;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.*;
import cz.cuni.amis.pogamut.defcon.consts.state.*;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

import javabot.JBot.UnitData;

/**
     * Contains all types of defcon units and supplies user with a factory method for each of them.
     * GENERATED by GameObjectsFactoryGenerator.xslt so any modifications should go there!!!     
     * 
     * @author Radek 'Black_Hand' Pibil          
     */
public enum UnitType {INVALID(JBot.TypeInvalid), CITY(JBot.TypeCity), SILO(JBot.TypeSilo), 
    RADAR(JBot.TypeRadarStation), NUKE(JBot.TypeNuke), EXPLOSION(JBot.TypeExplosion), 
    SUB(JBot.TypeSub), BATTLE_SHIP(JBot.TypeBattleShip), AIR_BASE(JBot.TypeAirBase), 
    FIGHTER(JBot.TypeFighter), BOMBER(JBot.TypeBomber), CARRIER(JBot.TypeCarrier), 
    TORNADO(JBot.TypeTornado), SAUCER(JBot.TypeSaucer), FLEET(JBot.TypeFleet), 
    GUNSHOT(JBot.TypeGunshot), QUEUE_ITEM(JBot.TypeQueueItem), NUM_OBJECTS(18);
    /**
     * Contains mapping from integer (defcon) unit type to UnitType enum. Used when
     * translation from "int" to UnitType is needed, i.e., when {@link UnitType#getEnum(int)} is
     * called.
     */
    private static Map<Integer, UnitType> enums = new HashMap<Integer, UnitType>();

    /**
     * Returns appropriate UnitType for given integer.
     *
     * @param id integer (defcon) id type
     *
     * @return UnitType type
     */
    public static UnitType getEnum(int id) {
        return enums.get(id);
    }

    static {
        for (UnitType item : UnitType.values()) {
            enums.put(item.id, item);
        }
    }

    /**
     * Holds integer (defcon) unit type of this unit..type.
     */
    public final int id;

    /**
     * Contains all units that can receive commands.<p></p>
     *  <p>SILO, RADAR, NUKE, SUB, BATTLE_SHIP, AIR_BASE, FIGHTER, BOMBER, CARRIER, FLEET
     * TODO: should NUKE be here?</p>
     */
    public static final EnumSet<UnitType> units;

    /**
     * Contains all air units that can receive commands.<p></p>
     *  <p>NUKE, FIGHTER, BOMBER TODO: should NUKE be here?</p>
     */
    public static final EnumSet<UnitType> air;

    /**
     * Contains all naval units that can receive commands.<p></p>
     *  <p>SUB, BATTLE_SHIP, CARRIER, FLEET</p>
     */
    public static final EnumSet<UnitType> naval;

    /**
     * Contains all ground units that can receive commands.<p></p>
     *  <p>SILO, RADAR, AIR_BASE</p>
     */
    public static final EnumSet<UnitType> ground;

    /**
     * All other types.<p></p>
     *  <p>INVALID, CITY, EXPLOSION, TORNADO, SAUCER, GUNSHOT, QUEUE_ITEM, NUM_OBJECTS</p>
     */
    public static final EnumSet<UnitType> misc;

/**
       * Constructor for this enum.
       *
       * @param id integer (defcon) unittype
       */
    private UnitType(int id) {
        this.id = id;
    }

    static {
        units = EnumSet.of(SILO, RADAR, NUKE, SUB, BATTLE_SHIP, AIR_BASE, FIGHTER, BOMBER, CARRIER,
                FLEET);
        air = EnumSet.of(NUKE, FIGHTER, BOMBER);
        naval = EnumSet.of(SUB, BATTLE_SHIP, CARRIER, FLEET);
        ground = EnumSet.of(SILO, RADAR, AIR_BASE);
        misc = EnumSet.of(INVALID, CITY, EXPLOSION, TORNADO, SAUCER, GUNSHOT, QUEUE_ITEM,
                NUM_OBJECTS);
    }

    /**
     * May the unit receive commands?<p></p>
     *  <p>SILO, RADAR, NUKE, SUB, BATTLE_SHIP, AIR_BASE, FIGHTER, BOMBER, CARRIER, FLEET</p>
     *
     * @return
     */
    public boolean isUnit() {
        return units.contains(this);
    }

    /**
     * Is the unit airborne?<p></p>
     *  <p>NUKE, FIGHTER, BOMBER</p>
     *
     * @return
     */
    public boolean isAir() {
        return air.contains(this);
    }

    /**
     * Is it ground unit?<p></p>
     *  <p>SILO, RADAR, AIR_BASE</p>
     *
     * @return
     */
    public boolean isGround() {
        return ground.contains(this);
    }

    /**
     * Is it naval unit?<p></p>
     *  <p>SUB, BATTLE_SHIP, CARRIER, FLEET</p>
     *
     * @return
     */
    public boolean isNaval() {
        return naval.contains(this);
    }

    /**
     * Is it misc?<p></p>
     *  <p>INVALID, CITY, EXPLOSION, TORNADO, SAUCER, GUNSHOT, QUEUE_ITEM, NUM_OBJECTS</p>
     *
     * @return
     */
    public boolean isMisc() {
        return misc.contains(this);
    }

    /**
     * Factory styled method, which provides you with an appropriate instance of unit
     * object based on the given UnitData data.
     *
     * @param data unit data
     * @param time time of creation
     *
     * @return instantiated defcon unit
     */
    public static DefConObject getInstanceOfUnitTypeFromUnitData(UnitData data, double time) {
        try {
            switch (UnitType.getEnum(data.m_type)) {
            case AIR_BASE:return new AirBase(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    AirBaseState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId),
                    JBot.GetStateCount(data.m_objectId, AirBaseState.FIGHTER_LAUNCH.getStateId()),
                    JBot.GetStateCount(data.m_objectId, AirBaseState.BOMBER_LAUNCH.getStateId()),
                    time);

            case BATTLE_SHIP:return new Battleship(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    BattleshipState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), time);

            case BOMBER:return new Bomber(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    BomberState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId),
                    new DefConLocation(JBot.GetBomberNukeTarget(data.m_objectId)), time);

            case CARRIER:return new Carrier(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    CarrierState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId),
                    JBot.GetStateCount(data.m_objectId, CarrierState.FIGHTER_LAUNCH.getStateId()),
                    JBot.GetStateCount(data.m_objectId, CarrierState.BOMBER_LAUNCH.getStateId()),
                    time);

            case CITY:return new City(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    JBot.GetCityPopulation(data.m_objectId), time);

            case EXPLOSION:return new Explosion(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);

            case FIGHTER:return new Fighter(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    FighterState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), time);

            case FLEET:return new Fleet(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    JBot.GetFleetMembers(data.m_objectId), time);

            case GUNSHOT:return new Gunshot(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);

            case INVALID:return new InvalidObject(data.m_objectId, time);

            case NUKE:return new Nuke(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    NukeState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), time);

            case QUEUE_ITEM:return new QueueItem(data.m_objectId, time);

            case RADAR:return new Radar(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    RadarState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), time);

            case SAUCER:return new Saucer(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);

            case SILO:return new Silo(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    SiloState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId),
                    time);

            case SUB:return new Sub(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible,
                    SubState.getState(data.m_currentState),
                    JBot.GetStateCount(data.m_objectId, data.m_currentState),
                    JBot.GetCurrentTargetId(data.m_objectId), JBot.GetNukeSupply(data.m_objectId),
                    time);

            case TORNADO:return new Tornado(data.m_objectId, data.m_teamId,
                    new DefConLocation(data.m_longitude, data.m_latitude), data.m_visible, time);
            }
        } catch (Exception e) {
        }

        return null;
    }

    /**
     * Provides mapping from UnitType to DefConObject class
     *
     * @return class of unit
     */
    public Class<?extends DefConObject> getClassOfUnitType() {
        return getClassOfUnitType(this);
    }

    /**
     * Provides mapping from UnitType to DefConObject class
     *
     * @param data unit type
     *
     * @return class of unit
     */
    public static Class<?extends DefConObject> getClassOfUnitType(UnitType data) {
        switch (data) {
        case AIR_BASE:return AirBase.class;

        case BATTLE_SHIP:return Battleship.class;

        case BOMBER:return Bomber.class;

        case CARRIER:return Carrier.class;

        case CITY:return City.class;

        case EXPLOSION:return Explosion.class;

        case FIGHTER:return Fighter.class;

        case FLEET:return Fleet.class;

        case GUNSHOT:return Gunshot.class;

        case INVALID:return InvalidObject.class;

        case NUKE:return Nuke.class;

        case QUEUE_ITEM:return QueueItem.class;

        case RADAR:return Radar.class;

        case SAUCER:return Saucer.class;

        case SILO:return Silo.class;

        case SUB:return Sub.class;

        case TORNADO:return Tornado.class;
        }

        return null;
    }
}
