package cz.cuni.amis.pogamut.defcon.agent.testbot;

import java.io.File;
import java.util.logging.Level;

import com.google.inject.Inject;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.params.impl.AgentParameters;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.agent.IDefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.communication.command.impl.DefConAct;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;

public class TestBot extends DefConAgent {


	@Inject
	public TestBot(IAgentId agentId, IComponentBus eventBus,
			IAgentLogger logger, DefConWorldView worldView, DefConAct act,
			IDefConAgentLogicController init) {
		super(agentId, eventBus, logger, worldView, act, init);

		getLogger().addToAllCategories(
				new LogPublisher.FilePublisher(new File(
						"Pogamut-TestBot.log")));
		getLogger().setLevel(Level.FINE);		
	}	
}
