package cz.cuni.amis.pogamut.defcon.consts;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * List of available chat channels to be passed.
 * Used in SendChatMessageCommand.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum ChatChannel {
	
	PUBLIC(JBot.CHATCHANNEL_PUBLIC),
	ALLIANCE(JBot.CHATCHANNEL_ALLIANCE),
	SPECTATORS(JBot.CHATCHANNEL_SPECTATORS);
	
	private static Map<Integer, ChatChannel> enums = new HashMap<Integer, ChatChannel>();
	
	public static ChatChannel getEnum(int id) {
		return enums.get(id);
	}
	
	static {
		for (ChatChannel item : ChatChannel.values()) {
			enums.put(item.id, item);
		}
	}
	
	public final int id;
	
	private ChatChannel(int id) {
		this.id = id;
	}

}
