/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.consts;

import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.CeasedFire;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConEvent;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Destroyed;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.Hit;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.NewVote;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.NukeLaunchSilo;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.NukeLaunchSub;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.PingCarrier;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.PingDetection;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.PingSub;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.SharedRadar;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.TeamRetractedVoted;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.TeamVoted;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.UnceasedFire;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.UnsharedRadar;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.VoteFinishedNo;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.VoteFinishedYes;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import java.util.HashMap;
import java.util.Map;
import javabot.JBot;

public enum Event {
    PING_SUB(0),
    PING_CARRIER(1),
    NUKE_LAUNCH_SILO(2),
    NUKE_LAUNCH_SUB(3),
    HIT(4),
    DESTROYED(5),
    PING_DETECTION(6),
    CEASED_FIRE(7),
    UNCEASED_FIRE(8),
    SHARED_RADAR(9),
    UNSHARED_RADAR(10),
    NEW_VOTE(11),
    TEAM_VOTED(12),
    TEAM_RETRACTED_VOTE(13),
    VOTE_FINISHED_YES(14),
    VOTE_FINISHED_NO(15);

    private static Map<Integer, Event> enums;
    public final int id;

    public static Event getEnum(int eventId) {
        return enums.get(eventId);
    }

    private Event(int id) {
        this.id = id;
    }

    public static DefConEvent getInstanceOfUnitTypeFromEventType(JBot.EventData data, double time) {
        switch (Event.getEnum(data.m_eventType)) {
            case SHARED_RADAR: {
                return new SharedRadar(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case PING_DETECTION: {
                return new PingDetection(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case HIT: {
                return new Hit(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case NUKE_LAUNCH_SUB: {
                return new NukeLaunchSub(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case VOTE_FINISHED_NO: {
                return new VoteFinishedNo(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case NEW_VOTE: {
                return new NewVote(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case UNSHARED_RADAR: {
                return new UnsharedRadar(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case DESTROYED: {
                return new Destroyed(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case TEAM_VOTED: {
                return new TeamVoted(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case PING_SUB: {
                return new PingSub(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case CEASED_FIRE: {
                return new CeasedFire(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case PING_CARRIER: {
                return new PingCarrier(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case VOTE_FINISHED_YES: {
                return new VoteFinishedYes(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case TEAM_RETRACTED_VOTE: {
                return new TeamRetractedVoted(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case UNCEASED_FIRE: {
                return new UnceasedFire(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
            case NUKE_LAUNCH_SILO: {
                return new NukeLaunchSilo(Event.getEnum(data.m_eventType), data.m_causeObjectId, data.m_targetObjectId, UnitType.getEnum(data.m_unitType), new DefConLocation(data.m_longitude, data.m_latitude), time);
            }
        }
        return null;
    }

    static {
        enums = new HashMap<Integer, Event>();
        for (Event item : Event.values()) {
            enums.put(item.id, item);
        }
    }
}

