/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridCell;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridCellId;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.SymmetricGridCellId;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;

public class SymmetricGridCell
implements IGridCell {
    protected SymmetricGridCellId cellId;
    protected static GameInfo gameInfo;

    public static void setGameInfo(GameInfo gameInfo) {
        SymmetricGridCell.gameInfo = gameInfo;
    }

    public SymmetricGridCell(SymmetricGridCellId cellId) {
        this.cellId = cellId;
    }

    public SymmetricGridCell(float x, float y) {
        this.cellId = new SymmetricGridCellId(x, y);
    }

    @Override
    public boolean hasFlag(BasicFlag flag) {
        return SymmetricGridCell.hasFlag(this.cellId.getX(), this.cellId.getY(), flag);
    }

    public static boolean hasFlag(Location location, BasicFlag flag) {
        return location != null && SymmetricGridCell.hasFlag((float)location.getX(), (float)location.getY(), flag);
    }

    public static boolean hasFlag(float x, float y, BasicFlag flag) {
        if (x < -180.0f || x > 180.0f || y < -90.0f || y > 90.0f) {
            return false;
        }
        switch (flag) {
            case SEA: {
                return gameInfo.isValidTerritory(-1, x, y, true);
            }
            case LAND: {
                return gameInfo.isValidTerritory(-1, x, y, false);
            }
            case OWN_TERRITORY: {
                int id = gameInfo.getOwnTeamId();
                return gameInfo.isValidTerritory(id, x, y, false) || gameInfo.isValidTerritory(id, x, y, true);
            }
            case ENEMY_TERRITORY: {
                int id;
                Boolean ok = false;
                int[] arr$ = gameInfo.getEnemyTeamIds();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(ok = Boolean.valueOf(gameInfo.isValidTerritory(id = arr$[i$], x, y, false) || gameInfo.isValidTerritory(id, x, y, true))).booleanValue(); ++i$) {
                }
                return ok;
            }
            case OWN_PLACEABLE_LAND: {
                return gameInfo.isValidPlacementLocation(x, y, UnitType.RADAR);
            }
            case OWN_PLACEABLE_SEA: {
                return gameInfo.isValidPlacementLocation(x, y, UnitType.BATTLE_SHIP);
            }
        }
        return false;
    }

    @Override
    public IGridCellId getCellId() {
        return this.cellId;
    }
}

