package cz.cuni.amis.pogamut.defcon.communication.messages.infos;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.defcon.communication.messages.Updatable;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;


/**
 * World object message of arbitrary world that is run in the same JVM.
 *
 * @author Jimmy
 * @author Black_Hand
 */
public abstract class DefConObject implements IWorldObject {
    /**
     * Private id of the world object, exposed via getId() method.
     */
    private WorldObjectId id;

    /**
     * Type of the world object, exposed via getType() method.
     */
    private UnitType type;

    /**
     * Time when the object was last updated. Exposed via getLastSeenTime().
     */
    @Updatable
    private double time;

    /**
     * DOCUMENT ME!
     */
    private boolean destroyed = false;

/**
     * Creates new object with specified id and time
     *
     * @param id id set to the object
     * @param type type of the unit
     * @param time time set to the object
     */
    public DefConObject(int id, UnitType type, double time) {
        this.id = WorldObjectId.get(id);
        this.type = type;
        this.time = time;
    }

/**
     * Creates a new DefConObject object.
     *
     * @param original DOCUMENT ME!
     */
    public DefConObject(DefConObject original) {
        this.id = original.getId();
        this.type = original.type;
        this.time = original.time;
    }

    /**
     * Returns ID of the object.
     *
     * @return ID
     */
    @Override
    public WorldObjectId getId() {
        return id;
    }

    /**
     * Returns type of this object.
     *
     * @return type
     */
    public UnitType getType() {
        return type;
    }

    /**
     * Returns the time of the last update of the object.
     *
     * @return time
     */
    public double getLastSeenTime() {
        return time;
    }

    /**
     * Sets the last-seen-time of the object.
     *
     * @param time
     */
    protected void setLastSeenTime(double time) {
        this.time = time;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    @Override
    public long getSimTime() {
        return (long) time;
    }

    /**
     * Returns update-event for the current object.
     *
     * @return update-event
     */
    public DefConObjectUpdate createUpdateEvent() {
        return new DefConObjectUpdate(this);
    }

    /**
     * Returns update-event for the current object.
     *
     * @return update-event
     */
    public DefConObjectUpdate createDestroyedEvent() {
        destroyed = true;

        return createUpdateEvent();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean getDestroyed() {
        return destroyed;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getStringizedFields() {
        return "id: " + id.toString() + "; type: " + type.toString() + "; time: " + time;
    }
}
