/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.utils.timekey;

import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimeKey
implements Comparable {
    private static FlagInteger instances = new FlagInteger(Integer.valueOf(0));
    private long _time;
    protected static Map<Long, WeakReference<TimeKey>> keys = new HashMap<Long, WeakReference<TimeKey>>(1024);

    public static ImmutableFlag<Integer> getInstances() {
        return instances.getImmutable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Map<Long, WeakReference<TimeKey>> map = keys;
        synchronized (map) {
            WeakReference<TimeKey> ref = keys.get(this._time);
            if (ref == null || ref.get() == null || ((TimeKey)ref.get())._time == this._time) {
                keys.remove(this._time);
            }
        }
        instances.decrement(1);
    }

    private TimeKey(long time) {
        instances.increment(1);
        this._time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeKey get(long time) {
        TimeKey key;
        WeakReference<TimeKey> ref = keys.get(time);
        if (ref != null && (key = (TimeKey)ref.get()) != null) {
            return key;
        }
        Map<Long, WeakReference<TimeKey>> map = keys;
        synchronized (map) {
            ref = keys.get(time);
            if (ref == null) {
                TimeKey key2 = new TimeKey(time);
                keys.put(time, new WeakReference<TimeKey>(key2));
                return key2;
            }
            TimeKey key3 = (TimeKey)ref.get();
            if (key3 == null) {
                key3 = new TimeKey(time);
                keys.put(time, new WeakReference<TimeKey>(key3));
                return key3;
            }
            return key3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Long, WeakReference<TimeKey>> map = keys;
        synchronized (map) {
            keys.clear();
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof TimeKey) {
            return ((TimeKey)other)._time == this._time;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this._time % Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(long time) {
        Map<Long, WeakReference<TimeKey>> map = keys;
        synchronized (map) {
            block6: {
                WeakReference<TimeKey> ref;
                block5: {
                    ref = keys.get(time);
                    if (ref != null) break block5;
                    return false;
                }
                if (ref.get() != null) break block6;
                keys.remove(time);
                return false;
            }
            return true;
        }
    }

    public long getTime() {
        return this._time;
    }

    public int compareTo(Object key) {
        if (this == key) {
            return 0;
        }
        if (key == null) {
            return 1;
        }
        if (!(key instanceof TimeKey)) {
            throw new ClassCastException("TimeKey can only be compared with TimeKey objects");
        }
        if (this._time < ((TimeKey)key)._time) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "TimeKey[" + this._time + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WeakReference<TimeKey>> getAllKeys() {
        Map<Long, WeakReference<TimeKey>> map = keys;
        synchronized (map) {
            return new ArrayList<WeakReference<TimeKey>>(keys.values());
        }
    }

    public static class TimeKeyComparator
    implements Comparator<TimeKey> {
        @Override
        public int compare(TimeKey o1, TimeKey o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1._time < o2._time) {
                return -1;
            }
            if (o1._time > o2._time) {
                return 1;
            }
            return 0;
        }
    }
}

