/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.worldview.ILocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedWorldObject;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.IStaticWorldObject;
import cz.cuni.amis.pogamut.multi.utils.exception.TimeKeyNotLockedException;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;
import cz.cuni.amis.utils.maps.AbstractLazyMap;
import cz.cuni.amis.utils.maps.HashMapSet;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.maps.WeakHashMapMap;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLocalWorldView
implements ILocalWorldView {
    public static final Token COMPONENT_ID = Tokens.get((String)"AbstractLocalWorldView");
    protected ISharedWorldView sharedWorldView;
    protected ITeamedAgentId agentId;
    protected Map<WorldObjectId, ILocalWorldObject> actLocalWorldObjects = Collections.synchronizedMap(new HashMap());
    protected HashMapSet<Class, WorldObjectId> classMap = new HashMapSet();
    protected Map<Class, Set<WorldObjectId>> syncClassMap = Collections.synchronizedMap(this.classMap);
    WeakHashMapMap<TimeKey, WorldObjectId, ILocalWorldObject> localWorldObjects = new WeakHashMapMap();
    HashMap compositeClassMap = new HashMap();
    WeakHashMapMap<TimeKey, WorldObjectId, ICompositeWorldObject> cachedCompositeWorldObjects = new WeakHashMapMap();
    TimeKey currentTimeKey;
    private ListenerNotifier notifier = new ListenerNotifier();
    private ListenersMap<Class> eventListeners = new ListenersMap();
    private ListenersMap<Class> objectsListeners = new ListenersMap();
    private Map<Class, ListenersMap<Class>> objectEventListeners = Collections.synchronizedMap(new LazyMap<Class, ListenersMap<Class>>(){

        protected ListenersMap<Class> create(Class key) {
            ListenersMap listeners = new ListenersMap();
            listeners.setLog((Logger)AbstractLocalWorldView.this.log, "LevelC-" + key.getSimpleName());
            return listeners;
        }
    });
    private ListenersMap<WorldObjectId> specificObjectListeners = new ListenersMap();
    private Map<WorldObjectId, ListenersMap<Class>> specificObjectEventListeners = Collections.synchronizedMap(new LazyMap<WorldObjectId, ListenersMap<Class>>(){

        protected ListenersMap<Class> create(WorldObjectId key) {
            ListenersMap listeners = new ListenersMap();
            listeners.setLog((Logger)AbstractLocalWorldView.this.log, "LevelE-" + key.getStringId());
            return listeners;
        }
    });
    private boolean raiseEventProcessing = false;
    private Queue<IWorldEvent> raiseEventsList = new ConcurrentLinkedQueue<IWorldEvent>();
    protected LogCategory log;
    protected ILifecycleBus eventBus;
    protected ComponentController<IComponent> controller;
    protected IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void start() throws PogamutException {
            AbstractLocalWorldView.this.log.finest("LocalWorldView [ " + AbstractLocalWorldView.this.agentId + " ] Starting...");
            AbstractLocalWorldView.this.start();
        }

        @Override
        public void prePause() throws PogamutException {
            AbstractLocalWorldView.this.prePause();
        }

        @Override
        public void pause() throws PogamutException {
            AbstractLocalWorldView.this.pause();
        }

        @Override
        public void resume() throws PogamutException {
            AbstractLocalWorldView.this.resume();
        }

        @Override
        public void preStop() throws PogamutException {
            AbstractLocalWorldView.this.preStop();
        }

        @Override
        public void stop() throws PogamutException {
            AbstractLocalWorldView.this.stop();
        }

        @Override
        public void kill() {
            AbstractLocalWorldView.this.kill();
        }

        @Override
        public void reset() {
            AbstractLocalWorldView.this.reset();
        }
    };

    public AbstractLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView sharedWV, ITeamedAgentId agentId) {
        this.log = logger.getCategory(this.getComponentId().getToken());
        this.agentId = agentId;
        this.eventBus = bus;
        this.controller = new ComponentController<AbstractLocalWorldView>(this, this.control, this.eventBus, (Logger)this.log, dependencies);
        this.sharedWorldView = sharedWV;
        this.sharedWorldView.registerLocalWorldView(this, bus);
        this.eventListeners.setLog((Logger)this.log, "LevelA");
        this.objectsListeners.setLog((Logger)this.log, "LevelB");
        this.specificObjectListeners.setLog((Logger)this.log, "LevelD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.actLocalWorldObjects;
        synchronized (object) {
            this.actLocalWorldObjects.clear();
        }
        object = this.classMap;
        synchronized (object) {
            this.classMap.clear();
        }
        object = this.raiseEventsList;
        synchronized (object) {
            this.raiseEventsList.clear();
        }
    }

    protected void start() {
        this.cleanUp();
    }

    protected void prePause() {
    }

    protected void pause() {
    }

    protected void resume() {
    }

    protected void preStop() {
    }

    protected void stop() {
        this.cleanUp();
    }

    protected void kill() {
        this.cleanUp();
    }

    protected void reset() {
        this.cleanUp();
    }

    protected boolean isRunning() {
        return this.controller.isRunning();
    }

    protected boolean isPaused() {
        return this.controller.isPaused();
    }

    public Token getComponentId() {
        return COMPONENT_ID;
    }

    protected abstract ICompositeWorldObject createCompositeObject(ILocalWorldObject var1, ISharedWorldObject var2, IStaticWorldObject var3);

    @Override
    public ITeamedAgentId getAgentId() {
        return this.agentId;
    }

    @Override
    public ILocalWorldObject getLocal(WorldObjectId objectId) {
        return this.getLocal(objectId, this.getCurrentTimeKey());
    }

    protected ILocalWorldObject getLocal(WorldObjectId objectId, TimeKey time) {
        ILocalWorldObject value = (ILocalWorldObject)this.localWorldObjects.get((Object)time, (Object)objectId);
        if (value != null) {
            return value;
        }
        return this.actLocalWorldObjects.get(objectId);
    }

    protected ICompositeWorldObject get(WorldObjectId objectId, TimeKey time) {
        ICompositeWorldObject obj = (ICompositeWorldObject)this.cachedCompositeWorldObjects.get((Object)time, (Object)objectId);
        if (obj != null) {
            return obj;
        }
        obj = this.createCompositeObject(this.getLocal(objectId, time), this.sharedWorldView.getShared(this.agentId.getTeamId(), objectId, time), this.sharedWorldView.getStatic(objectId));
        this.cachedCompositeWorldObjects.put((Object)time, (Object)objectId, (Object)obj);
        return obj;
    }

    @Override
    public ICompositeWorldObject get(WorldObjectId objectId) {
        return this.get(objectId, this.getCurrentTimeKey());
    }

    @Override
    public <T extends ICompositeWorldObject> T get(WorldObjectId objectId, Class<T> clazz) {
        ICompositeWorldObject obj = this.get(objectId);
        if (obj == null) {
            return null;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        throw new ClassCastException("Object with id " + objectId + " is not of class " + clazz);
    }

    protected Map<Class, Map<WorldObjectId, ICompositeWorldObject>> getAll(TimeKey time) {
        for (Object oC : this.compositeClassMap.keySet()) {
            Class c = (Class)oC;
            ((LazyCompositeObjectMap)((Object)this.compositeClassMap.get(c))).setTimeKey(time.getTime());
        }
        return this.compositeClassMap;
    }

    @Override
    public Map<Class, Map<WorldObjectId, ICompositeWorldObject>> getAll() {
        return this.getAll(this.getCurrentTimeKey());
    }

    protected <T extends IWorldObject> Map<WorldObjectId, T> getAll(Class<T> type, TimeKey time) {
        LazyCompositeObjectMap map = (LazyCompositeObjectMap)((Object)this.compositeClassMap.get(type));
        if (map == null) {
            map = new LazyCompositeObjectMap(time.getTime());
            this.compositeClassMap.put(type, map);
            return map;
        }
        map.setTimeKey(time.getTime());
        return map;
    }

    @Override
    public <T extends IWorldObject> Map<WorldObjectId, T> getAll(Class<T> type) {
        return this.getAll(type, this.getCurrentTimeKey());
    }

    @Override
    public Map<WorldObjectId, ICompositeWorldObject> get() {
        return this.get(this.getCurrentTimeKey());
    }

    protected Map<WorldObjectId, ICompositeWorldObject> get(TimeKey time) {
        LazyCompositeObjectMap objects = new LazyCompositeObjectMap(this.actLocalWorldObjects.keySet(), time.getTime());
        return objects;
    }

    @Override
    public <T extends IWorldObject> T getSingle(Class<T> cls) {
        return this.getSingle(cls, this.getCurrentTimeKey());
    }

    protected <T extends IWorldObject> T getSingle(Class<T> cls, TimeKey time) {
        Collection<T> vals = this.getAll(cls, time).values();
        if (vals.size() == 1) {
            return (T)((IWorldObject)vals.iterator().next());
        }
        throw new IllegalArgumentException();
    }

    protected ILocalWorldObject getMostRecentLocalWorldObject(WorldObjectId id) {
        return this.actLocalWorldObjects.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addOldLocalWorldObject(ILocalWorldObject obj, long eventTime) {
        for (Long time : TimeKeyManager.get().getHeldKeys()) {
            if (time >= eventTime) continue;
            WeakHashMapMap<TimeKey, WorldObjectId, ILocalWorldObject> weakHashMapMap = this.localWorldObjects;
            synchronized (weakHashMapMap) {
                TimeKey timeKey = TimeKey.get(time);
                if (this.localWorldObjects.get((Object)timeKey, (Object)obj.getId()) == null) {
                    this.localWorldObjects.put((Object)timeKey, (Object)obj.getId(), (Object)obj);
                }
            }
        }
    }

    protected synchronized void addLocalWorldObject(ILocalWorldObject obj) {
        this.actLocalWorldObjects.put(obj.getId(), obj);
        for (Class cls : ClassUtils.getSubclasses((Class)obj.getCompositeClass())) {
            LazyCompositeObjectMap map = (LazyCompositeObjectMap)((Object)this.compositeClassMap.get(cls));
            if (map == null) {
                map = new LazyCompositeObjectMap(this.currentTimeKey.getTime());
                this.compositeClassMap.put(cls, map);
            }
            map.keySet().add(obj.getId());
            this.syncClassMap.get(cls).add(obj.getId());
        }
    }

    protected synchronized void removeLocalWorldObject(ILocalWorldObject obj) {
        this.actLocalWorldObjects.remove(obj.getId());
        for (Class cls : ClassUtils.getSubclasses((Class)obj.getCompositeClass())) {
            LazyCompositeObjectMap map = (LazyCompositeObjectMap)((Object)this.compositeClassMap.get(cls));
            if (map != null) {
                map.keySet().remove(obj.getId());
            }
            this.syncClassMap.get(cls).remove(obj.getId());
        }
    }

    @Override
    public boolean setInitialTime(TimeKey key) {
        if (this.currentTimeKey == null) {
            this.currentTimeKey = key;
            return true;
        }
        return false;
    }

    @Override
    public boolean setCurrentTime(TimeKey key) {
        this.currentTimeKey = key;
        return true;
    }

    @Override
    public TimeKey getCurrentTimeKey() {
        return this.currentTimeKey;
    }

    @Override
    public void lockTime(long time) {
        TimeKeyManager.get().lock(time);
    }

    @Override
    public void unlockTime(long time) {
        try {
            TimeKeyManager.get().unlock(time);
        }
        catch (TimeKeyNotLockedException e) {
            this.log.warning("Trying to unlock timeKey : " + time + " which is not locked. ");
        }
    }

    @Override
    public void addEventListener(Class<?> event, IWorldEventListener<?> listener) {
        this.eventListeners.add(event, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        this.objectsListeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
        listeners.add(objectClass, listener);
    }

    @Override
    public void addObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        this.specificObjectListeners.add((Object)objectId, listener);
    }

    @Override
    public void addObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        listeners.add(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> eventClass, IWorldEventListener<?> listener) {
        return this.eventListeners.isListening(eventClass, listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        return this.objectsListeners.isListening(listener);
    }

    @Override
    public boolean isListening(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(objectClass)) {
            return this.objectEventListeners.get(eventClass).isListening(objectClass, listener);
        }
        return false;
    }

    @Override
    public boolean isListening(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        return this.specificObjectListeners.isListening((Object)objectId, listener);
    }

    @Override
    public boolean isListening(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            return this.specificObjectEventListeners.get(objectId).isListening(eventClass, listener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isListening(IWorldEventListener<?> listener) {
        ListenersMap<Class> listeners;
        Iterator<ListenersMap<Class>> iterator;
        Map<Serializable, ListenersMap<Class>> map;
        block9: {
            if (this.eventListeners.isListening(listener)) return true;
            if (this.specificObjectListeners.isListening(listener)) {
                return true;
            }
            map = this.objectEventListeners;
            synchronized (map) {
                iterator = this.objectEventListeners.values().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    break block9;
                } while (!(listeners = iterator.next()).isListening(listener));
                return true;
            }
        }
        map = this.specificObjectEventListeners;
        synchronized (map) {
            iterator = this.specificObjectEventListeners.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(listeners = iterator.next()).isListening(listener));
            return true;
        }
    }

    @Override
    public void removeEventListener(Class<?> eventClass, IWorldEventListener<?> listener) {
        this.eventListeners.remove(eventClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
        this.objectsListeners.remove(objectClass, listener);
    }

    @Override
    public void removeObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.objectEventListeners.containsKey(eventClass)) {
            this.objectEventListeners.get(eventClass).remove(objectClass, listener);
        }
    }

    @Override
    public void removeObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
        this.specificObjectListeners.remove((Object)objectId, listener);
    }

    @Override
    public void removeObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
        if (this.specificObjectEventListeners.containsKey(objectId)) {
            this.specificObjectEventListeners.get(objectId).remove(eventClass, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IWorldEventListener<?> listener) {
        this.eventListeners.remove(listener);
        Map<Class, ListenersMap<Class>> map = this.objectEventListeners;
        synchronized (map) {
            for (ListenersMap<Class> listeners : this.objectEventListeners.values()) {
                listeners.remove(listener);
            }
        }
        this.specificObjectListeners.remove(listener);
        this.specificObjectEventListeners.remove(listener);
    }

    protected synchronized void raiseEvent(IWorldEvent event) {
        if (this.raiseEventProcessing) {
            this.raiseEventsList.add(event);
            return;
        }
        this.raiseEventProcessing = true;
        this.innerRaiseEvent(event);
        while (this.raiseEventsList.size() != 0) {
            this.innerRaiseEvent(this.raiseEventsList.poll());
        }
        this.raiseEventProcessing = false;
    }

    private void notifyLevelAListeners(IWorldEvent event) {
        Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            this.eventListeners.notify((Object)eventClass, (Listeners.ListenerNotifier)this.notifier);
        }
    }

    private void notifyLevelBListeners(IWorldObjectEvent event) {
        Object object = event.getObject();
        Collection objectClasses = ClassUtils.getSubclasses(object.getClass());
        this.notifier.setEvent(event);
        for (Class objectClass : objectClasses) {
            this.objectsListeners.notify((Object)objectClass, (Listeners.ListenerNotifier)this.notifier);
        }
    }

    private void notifyLevelCListeners(IWorldObjectEvent event) {
        Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
        Collection objectClasses = ClassUtils.getSubclasses(event.getObject().getClass());
        this.notifier.setEvent(event);
        for (Class eventClass : eventClasses) {
            ListenersMap<Class> listeners = this.objectEventListeners.get(eventClass);
            if (listeners == null || !listeners.hasListeners()) continue;
            for (Class objectClass : objectClasses) {
                listeners.notify((Object)objectClass, (Listeners.ListenerNotifier)this.notifier);
            }
        }
    }

    private void notifyLevelDListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        this.specificObjectListeners.notify((Object)event.getId(), (Listeners.ListenerNotifier)this.notifier);
    }

    private void notifyLevelEListeners(IWorldObjectEvent event) {
        this.notifier.setEvent(event);
        WorldObjectId objectId = event.getId();
        ListenersMap<Class> listeners = this.specificObjectEventListeners.get(objectId);
        if (listeners.hasListeners()) {
            Collection eventClasses = ClassUtils.getSubclasses(event.getClass());
            this.notifier.setEvent(event);
            for (Class eventClass : eventClasses) {
                listeners.notify((Object)eventClass, (Listeners.ListenerNotifier)this.notifier);
            }
        }
    }

    private void innerRaiseEvent(IWorldEvent event) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("notifying " + event);
        }
        this.notifyLevelAListeners(event);
        if (event instanceof IWorldObjectEvent) {
            IWorldObjectEvent objectEvent = (IWorldObjectEvent)event;
            this.notifyLevelBListeners(objectEvent);
            this.notifyLevelCListeners(objectEvent);
            this.notifyLevelDListeners(objectEvent);
            this.notifyLevelEListeners(objectEvent);
        }
    }

    @Override
    public ILifecycleBus getEventBus() {
        return this.eventBus;
    }

    protected class LazyCompositeObjectMap<T extends ICompositeWorldObject>
    extends AbstractLazyMap<WorldObjectId, T> {
        private long currentTime;
        private WeakReference<TimeKey> timeKey;

        public LazyCompositeObjectMap(long time) {
            this.currentTime = time;
            this.timeKey = new WeakReference<TimeKey>(TimeKey.get(this.currentTime));
        }

        LazyCompositeObjectMap(Set<WorldObjectId> keySet, long time) {
            super(keySet);
            this.currentTime = time;
            this.timeKey = new WeakReference<TimeKey>(TimeKey.get(this.currentTime));
        }

        public boolean setTimeKey(long newTime) {
            if (AbstractLocalWorldView.this.currentTimeKey.equals(newTime)) {
                return false;
            }
            super.clearCache();
            this.currentTime = newTime;
            this.timeKey = new WeakReference<TimeKey>(TimeKey.get(this.currentTime));
            return true;
        }

        protected T create(Object key) {
            return (T)AbstractLocalWorldView.this.get((WorldObjectId)key, (TimeKey)this.timeKey.get());
        }
    }

    private static class ListenerNotifier<T>
    implements Listeners.ListenerNotifier<IListener> {
        private T event = null;

        private ListenerNotifier() {
        }

        public T getEvent() {
            return this.event;
        }

        public void setEvent(T event) {
            this.event = event;
        }

        public void notify(IListener listener) {
            listener.notify(this.event);
        }
    }
}

