/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import java.util.HashSet;
import java.util.Set;

public class ComponentDependencies {
    Set<IToken> tokenDependencies = new HashSet<IToken>();
    private ComponentDependencyType type;

    public ComponentDependencies() {
        this(ComponentDependencyType.STARTS_WITH);
    }

    public ComponentDependencies(ComponentDependencyType dependencyType) {
        this.type = dependencyType;
        NullCheck.check((Object)((Object)this.type), (String)"dependencyType");
    }

    public ComponentDependencies(ComponentDependencyType dependencyType, Object ... dependencies) {
        this.type = dependencyType;
        NullCheck.check((Object)((Object)this.type), (String)"dependencyType");
        NullCheck.check((Object)dependencies, (String)"dependencies");
        int i = 0;
        while (i < dependencies.length) {
            NullCheck.check((Object)dependencies[i], (String)("dependencies[" + i + "]"));
            if (dependencies[i] instanceof IToken) {
                this.add((IToken)dependencies[i]);
            } else if (dependencies[i] instanceof IComponent) {
                if (((IComponent)dependencies[i]).getComponentId() == null) {
                    throw new IllegalArgumentException("dependencies[" + i + "].getComponentId() is null");
                }
                this.add((IComponent)dependencies[i]);
            } else {
                throw new IllegalArgumentException("dependencies[" + i + "] is not IToken nor IComponent");
            }
            ++i;
        }
    }

    public ComponentDependencies(ComponentDependencies dependencies) {
        NullCheck.check((Object)dependencies, (String)"dependencies");
        this.type = dependencies.type;
        for (IToken token : dependencies.tokenDependencies) {
            this.tokenDependencies.add(token);
        }
    }

    public ComponentDependencies add(IToken token) {
        NullCheck.check((Object)token, (String)"token");
        this.tokenDependencies.add(token);
        return this;
    }

    public ComponentDependencies add(IComponent component) {
        NullCheck.check((Object)component, (String)"component");
        NullCheck.check((Object)component.getComponentId(), (String)"'component's id'");
        this.tokenDependencies.add(component.getComponentId());
        return this;
    }

    public IToken[] getDependencies() {
        return this.tokenDependencies.toArray(new IToken[0]);
    }

    public boolean isDependency(IToken token) {
        return this.tokenDependencies.contains(token);
    }

    public boolean isDependency(IComponent component) {
        return this.isDependency(component.getComponentId());
    }

    public ComponentDependencyType getType() {
        return this.type;
    }

    public int getCount() {
        return this.tokenDependencies.size();
    }

    public String toString() {
        return "ComponentDependencies";
    }
}

