/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus.event;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppingEvent;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentBusEvents {
    protected IComponentBus bus;
    protected IComponent component;
    protected Logger log;
    protected boolean broadcasting = true;

    public ComponentBusEvents(IComponentBus bus, IComponent component, Logger log) {
        this.bus = bus;
        this.component = component;
        this.log = log;
    }

    public boolean isBroadcasting() {
        return this.broadcasting;
    }

    public void setBroadcasting(boolean broadcasting) {
        this.broadcasting = broadcasting;
    }

    private boolean event(IComponentEvent event) {
        if (!this.isBroadcasting()) {
            if (this.log != null && this.log.isLoggable(Level.FINEST)) {
                this.log.finest(String.valueOf(this.component.getComponentId().getToken()) + " WON'T SEND " + event + " to " + this.bus + " as broadcasting is DISABLED");
            }
            return false;
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.component.getComponentId().getToken()) + " is sending " + event + " to " + this.bus);
        }
        if (this.bus.event(event)) {
            if (this.log != null && this.log.isLoggable(Level.FINEST)) {
                this.log.finest(String.valueOf(this.component.getComponentId().getToken()) + " sent " + event + " to " + this.bus + " and was processed");
            }
            return true;
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.warning(String.valueOf(this.component.getComponentId().getToken()) + " sent StartingEvent to " + this.bus + " and its processing was postponed.");
        }
        return false;
    }

    private boolean eventTransactional(IComponentEvent event) {
        if (!this.isBroadcasting()) {
            if (this.log != null && this.log.isLoggable(Level.FINEST)) {
                this.log.finest(String.valueOf(this.component.getComponentId().getToken()) + " WON'T SEND TRANSACTIONAL " + event + " to " + this.bus + " as broadcasting is DISABLED");
            }
            return false;
        }
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.component.getComponentId().getToken()) + " is sending transactional " + event + " to " + this.bus);
        }
        this.bus.eventTransactional(event);
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.valueOf(this.component.getComponentId().getToken()) + " sent transactional " + event + " to " + this.bus + " and was processed");
        }
        return true;
    }

    public boolean starting() {
        return this.event(new StartingEvent<IComponent>(this.component));
    }

    public boolean starting(String message) {
        return this.event(new StartingEvent<IComponent>(this.component, message));
    }

    public boolean startingPaused() {
        return this.event(new StartingPausedEvent<IComponent>(this.component));
    }

    public boolean startingPaused(String message) {
        return this.event(new StartingPausedEvent<IComponent>(this.component, message));
    }

    public boolean started() {
        return this.event(new StartedEvent<IComponent>(this.component));
    }

    public boolean started(String message) {
        return this.event(new StartedEvent<IComponent>(this.component, message));
    }

    public boolean pausing() {
        return this.event(new PausingEvent<IComponent>(this.component));
    }

    public boolean pausing(String message) {
        return this.event(new PausingEvent<IComponent>(this.component, message));
    }

    public boolean paused() {
        return this.event(new PausedEvent<IComponent>(this.component));
    }

    public boolean paused(String message) {
        return this.event(new PausedEvent<IComponent>(this.component, message));
    }

    public boolean resuming() {
        return this.event(new ResumingEvent<IComponent>(this.component));
    }

    public boolean resuming(String message) {
        return this.event(new ResumingEvent<IComponent>(this.component, message));
    }

    public boolean resumed() {
        return this.event(new ResumedEvent<IComponent>(this.component));
    }

    public boolean resumed(String message) {
        return this.event(new ResumedEvent<IComponent>(this.component, message));
    }

    public boolean stopping() {
        return this.event(new StoppingEvent<IComponent>(this.component));
    }

    public boolean stopping(String message) {
        return this.event(new StoppingEvent<IComponent>(this.component, message));
    }

    public boolean stopped() {
        return this.event(new StoppedEvent<IComponent>(this.component));
    }

    public boolean stopped(String message) {
        return this.event(new StoppedEvent<IComponent>(this.component, message));
    }

    public boolean fatalError(String message) {
        return this.event(new FatalErrorEvent<IComponent>(this.component, message));
    }

    public boolean fatalError(String message, Throwable cause) {
        return this.event(new FatalErrorEvent<IComponent>(this.component, message, cause));
    }

    public boolean fatalError(Throwable cause) {
        return this.event(new FatalErrorEvent<IComponent>(this.component, cause));
    }

    public boolean startingTransactional() {
        return this.eventTransactional(new StartingEvent<IComponent>(this.component));
    }

    public boolean startingTransactional(String message) {
        return this.eventTransactional(new StartingEvent<IComponent>(this.component, message));
    }

    public boolean startingPausedTransactional() {
        return this.eventTransactional(new StartingPausedEvent<IComponent>(this.component));
    }

    public boolean startingPausedTransactional(String message) {
        return this.eventTransactional(new StartingPausedEvent<IComponent>(this.component, message));
    }

    public boolean startedTransactional() {
        return this.eventTransactional(new StartedEvent<IComponent>(this.component));
    }

    public boolean startedTransactional(String message) {
        return this.eventTransactional(new StartedEvent<IComponent>(this.component, message));
    }

    public boolean pausingTransactional() {
        return this.eventTransactional(new PausingEvent<IComponent>(this.component));
    }

    public boolean pausingTransactional(String message) {
        return this.eventTransactional(new PausingEvent<IComponent>(this.component, message));
    }

    public boolean pausedTransactional() {
        return this.eventTransactional(new PausedEvent<IComponent>(this.component));
    }

    public boolean pausedTransactional(String message) {
        return this.eventTransactional(new PausedEvent<IComponent>(this.component, message));
    }

    public boolean resumingTransactional() {
        return this.eventTransactional(new ResumingEvent<IComponent>(this.component));
    }

    public boolean resumingTransactional(String message) {
        return this.eventTransactional(new ResumingEvent<IComponent>(this.component, message));
    }

    public boolean resumedTransactional() {
        return this.eventTransactional(new ResumedEvent<IComponent>(this.component));
    }

    public boolean resumedTransactional(String message) {
        return this.eventTransactional(new ResumedEvent<IComponent>(this.component, message));
    }

    public boolean stoppingTransactional() {
        return this.eventTransactional(new StoppingEvent<IComponent>(this.component));
    }

    public boolean stoppingTransactional(String message) {
        return this.eventTransactional(new StoppingEvent<IComponent>(this.component, message));
    }

    public boolean stoppedTransactional() {
        return this.eventTransactional(new StoppedEvent<IComponent>(this.component));
    }

    public boolean stoppedTransactional(String message) {
        return this.eventTransactional(new StoppedEvent<IComponent>(this.component, message));
    }
}

