/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.IListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.exception.ListenerMethodParametersException;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.exception.MoreThanOneListenerLevelAnnotationException;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.exception.ListenersAlreadyRegisteredException;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.Lazy;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.LazyMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationListenerRegistrator
implements IListenerRegistrator {
    private IWorldView worldView;
    private Object obj;
    private boolean listenersRegistered = false;
    private Lazy<List<Method>> methods = new Lazy<List<Method>>(){

        protected List<Method> create() {
            return AnnotationListenerRegistrator.this.probeMethods();
        }
    };
    private Map<ListenerLevel, List<IWorldEventListener>> listeners = new LazyMap<ListenerLevel, List<IWorldEventListener>>(){

        protected List<IWorldEventListener> create(ListenerLevel key) {
            return new ArrayList<IWorldEventListener>();
        }
    };
    private Logger log;

    public static WorldObjectId getId(Method method, Class idClass, String id) {
        try {
            Object newId = null;
            Constructor constructor = null;
            try {
                constructor = idClass.getConstructor(String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (constructor != null) {
                newId = idClass.getConstructor(String.class).newInstance(id);
            } else {
                Method getMethod = null;
                try {
                    getMethod = idClass.getMethod("get", String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (getMethod != null && AnnotationListenerRegistrator.isStaticMethod(getMethod) && getMethod.getReturnType().isAssignableFrom(idClass)) {
                    newId = getMethod.invoke((Object)idClass, id);
                } else {
                    throw new IllegalArgumentException("Creation of ID for the annotation on the method " + ClassUtils.getMethodSignature((Method)method) + " has failed. Can't create object ID, id class " + idClass + " for id '" + id + "', as id class has neither constructor with String as parameter, nor static get(String) method for obtaining ids.");
                }
            }
            if (newId == null) {
                throw new IllegalArgumentException("Creation of ID for the annotation on the method " + ClassUtils.getMethodSignature((Method)method) + " has failed. Failed to instantiate ID '" + id + "' using id class " + idClass + ", result id is NULL! Have you specified correct idClass?");
            }
            if (!newId.getClass().isAssignableFrom(idClass)) {
                throw new IllegalArgumentException("Creation of ID for the annotation on the method " + ClassUtils.getMethodSignature((Method)method) + " has failed. Failed to instantiate CORRECT ID '" + id + "' using id class " + idClass + ". Result id is of incompatible class " + newId.getClass() + ". Have you specified correct idClass?");
            }
            if (!WorldObjectId.class.isAssignableFrom(newId.getClass())) {
                throw new IllegalArgumentException("Creation of ID for the annotation on the method " + ClassUtils.getMethodSignature((Method)method) + " has failed. Failed to instantiate CORRECT ID '" + id + "' using id class " + idClass + ". Result id is of incompatible class " + newId.getClass() + " as it does not extends WorldObjectId class. Have you specified correct idClass?");
            }
            return (WorldObjectId)newId;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Creation of ID for the annotation on the method " + ClassUtils.getMethodSignature((Method)method) + " has failed. Failed to instantiate CORRECT ID '" + id + "' using id class " + idClass + ". Exception occured during reflection.", e);
        }
    }

    public static WorldObjectId getId(Method method, ObjectListener annotation) {
        NullCheck.check((Object)method, (String)"method");
        NullCheck.check((Object)annotation, (String)"annotation");
        if (annotation.idClass() == null) {
            throw new IllegalArgumentException(String.valueOf(ClassUtils.getMethodSignature((Method)method)) + "-@ObjectListener.idClass == null, specify class of the id!");
        }
        if (annotation.objectId() == null) {
            throw new IllegalArgumentException(String.valueOf(ClassUtils.getMethodSignature((Method)method)) + "-@ObjectListener.idClass == null, specify class of the id!");
        }
        return AnnotationListenerRegistrator.getId(method, annotation.idClass(), annotation.objectId());
    }

    public static boolean isStaticMethod(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static WorldObjectId getId(Method method, ObjectEventListener annotation) {
        NullCheck.check((Object)method, (String)"method");
        NullCheck.check((Object)annotation, (String)"annotation");
        if (annotation.idClass() == null) {
            throw new IllegalArgumentException(String.valueOf(ClassUtils.getMethodSignature((Method)method)) + "-@ObjectEventListener.idClass == null, specify class of the id!");
        }
        if (annotation.objectId() == null) {
            throw new IllegalArgumentException(String.valueOf(ClassUtils.getMethodSignature((Method)method)) + "-@ObjectEventListener.idClass == null, specify class of the id!");
        }
        return AnnotationListenerRegistrator.getId(method, annotation.idClass(), annotation.objectId());
    }

    public static ListenerLevel getListenerLevel(Method method) {
        ListenerLevel level = null;
        if (method.isAnnotationPresent(EventListener.class)) {
            level = ListenerLevel.A;
        }
        if (method.isAnnotationPresent(ObjectClassListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.B;
        }
        if (method.isAnnotationPresent(ObjectClassEventListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.C;
        }
        if (method.isAnnotationPresent(ObjectListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.D;
        }
        if (method.isAnnotationPresent(ObjectEventListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.E;
        }
        return level;
    }

    public AnnotationListenerRegistrator(Object obj, IWorldView worldView, Logger log) {
        this.worldView = worldView;
        NullCheck.check((Object)this.worldView, (String)"worldView");
        this.obj = obj;
        NullCheck.check((Object)this.obj, (String)"obj");
        this.log = log;
        NullCheck.check((Object)this.log, (String)"log");
    }

    private List<Method> probeMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] methodArray = this.obj.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (AnnotationListenerRegistrator.getListenerLevel(method) != null) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    @Override
    public synchronized void addListeners() throws ListenersAlreadyRegisteredException {
        if (this.listenersRegistered) {
            throw new ListenersAlreadyRegisteredException(this);
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(this.obj + " -> " + this.worldView + ": Registering listeners.");
        }
        for (Method method : (List)this.methods.getVal()) {
            switch (AnnotationListenerRegistrator.getListenerLevel(method)) {
                case A: {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.obj + " -> " + this.worldView + ": Registering level A listener for " + ClassUtils.getMethodSignature((Method)method));
                    }
                    LevelAListener listenerA = new LevelAListener(method);
                    this.worldView.addEventListener(listenerA.getEventClass(), listenerA);
                    this.listeners.get((Object)ListenerLevel.A).add(listenerA);
                    break;
                }
                case B: {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.obj + " -> " + this.worldView + ": Registering level B listener for " + ClassUtils.getMethodSignature((Method)method));
                    }
                    LevelBListener listenerB = new LevelBListener(method);
                    this.worldView.addObjectListener(listenerB.getObjectClass(), listenerB);
                    this.listeners.get((Object)ListenerLevel.B).add(listenerB);
                    break;
                }
                case C: {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.obj + " -> " + this.worldView + ": Registering level C listener for " + ClassUtils.getMethodSignature((Method)method));
                    }
                    LevelCListener listenerC = new LevelCListener(method);
                    this.worldView.addObjectListener(listenerC.getObjectClass(), listenerC.getEventClass(), listenerC);
                    this.listeners.get((Object)ListenerLevel.C).add(listenerC);
                    break;
                }
                case D: {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.obj + " -> " + this.worldView + ": Registering level D listener for " + ClassUtils.getMethodSignature((Method)method));
                    }
                    LevelDListener listenerD = new LevelDListener(method);
                    this.worldView.addObjectListener(listenerD.getObjectId(), listenerD);
                    this.listeners.get((Object)ListenerLevel.D).add(listenerD);
                    break;
                }
                case E: {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.obj + " -> " + this.worldView + ": Registering level E listener for " + ClassUtils.getMethodSignature((Method)method));
                    }
                    LevelEListener listenerE = new LevelEListener(method);
                    this.worldView.addObjectListener(listenerE.getObjectId(), listenerE.getEventClass(), listenerE);
                    this.listeners.get((Object)ListenerLevel.E).add(listenerE);
                }
            }
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.obj + " -> " + this.worldView + ": Registered " + this.listeners.size() + " listeners.");
        }
    }

    public int getListenersCount() {
        return this.listeners.get((Object)ListenerLevel.A).size() + this.listeners.get((Object)ListenerLevel.B).size() + this.listeners.get((Object)ListenerLevel.C).size() + this.listeners.get((Object)ListenerLevel.D).size() + this.listeners.get((Object)ListenerLevel.E).size();
    }

    @Override
    public synchronized void removeListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(this.obj + " -> " + this.worldView + ": Removing " + this.getListenersCount() + " listeners.");
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.A)) {
            LevelAListener listenerA = (LevelAListener)l;
            this.worldView.removeEventListener(listenerA.getEventClass(), listenerA);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.B)) {
            LevelBListener listenerB = (LevelBListener)l;
            this.worldView.removeObjectListener(listenerB.getObjectClass(), listenerB);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.C)) {
            LevelCListener listenerC = (LevelCListener)l;
            this.worldView.removeObjectListener(listenerC.getObjectClass(), listenerC.getEventClass(), listenerC);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.D)) {
            LevelDListener listenerD = (LevelDListener)l;
            this.worldView.removeObjectListener(listenerD.getObjectId(), listenerD);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.E)) {
            LevelEListener listenerE = (LevelEListener)l;
            this.worldView.removeObjectListener(listenerE.getObjectId(), listenerE.getEventClass(), listenerE);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.obj + " -> " + this.worldView + ": Listeners removed.");
        }
    }

    public Logger getLog() {
        return this.log;
    }

    private class LevelAListener
    implements IWorldEventListener {
        Method method;

        public LevelAListener(Method method) {
            NullCheck.check((Object)method, (String)"method");
            this.method = method;
            if (this.getAnnotation() == null) {
                throw new ListenerMethodParametersException(method, "There is no EventListener annotation on the method!", AnnotationListenerRegistrator.this);
            }
            if (this.getEventClass() == null) {
                throw new ListenerMethodParametersException(method, "EventListener.eventClass can't be null!", AnnotationListenerRegistrator.this);
            }
            if (!IWorldEvent.class.isAssignableFrom(this.getEventClass())) {
                throw new ListenerMethodParametersException(method, "EventListener.eventClass == " + this.getEventClass() + " is not instance of IWorldEvent! Are you trying to use the listener for IWorldObjects? If so, see usage of ObjectClassEventListener or ObjectClassListener or ObjectEventListener or ObjectListener as used inside ResponsiveBot PogamutUT2004 example!", AnnotationListenerRegistrator.this);
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(EventListener.class).eventClass())) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(EventListener.class), AnnotationListenerRegistrator.this);
            }
            if (method.getParameterTypes()[0].isAssignableFrom(IWorldObject.class)) {
                throw new ListenerMethodParametersException(method, "EventListener can't be used to listen for OBJECTS! You must use ObjectClassEventListener or ObjectClassListener or ObjectEventListener or ObjectListener annotation for that! See ResponsiveBot PogamutUT2004 example!", AnnotationListenerRegistrator.this);
            }
        }

        public EventListener getAnnotation() {
            return this.method.getAnnotation(EventListener.class);
        }

        public Class getEventClass() {
            return this.getAnnotation().eventClass();
        }

        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelA listener " + ClassUtils.getMethodSignature((Method)this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, (Object)this);
            }
        }
    }

    private class LevelBListener
    implements IWorldObjectListener {
        Method method;

        public LevelBListener(Method method) {
            NullCheck.check((Object)method, (String)"method");
            this.method = method;
            if (this.getAnnotation() == null) {
                throw new ListenerMethodParametersException(method, "There is no ObjectClassListener annotation on the method!", AnnotationListenerRegistrator.this);
            }
            if (this.getObjectClass() == null) {
                throw new ListenerMethodParametersException(method, "ObjectClassListener.objectClass can't be null!", AnnotationListenerRegistrator.this);
            }
            if (!IWorldObject.class.isAssignableFrom(this.getObjectClass())) {
                throw new ListenerMethodParametersException(method, "ObjectClassListener.objectClass == " + this.getObjectClass() + " is not instance of IWorldObject! Are you trying to use the listener for IWorldEvent? If so, use EventListener, see the example inside ResponsiveBot PogamutUT2004!", AnnotationListenerRegistrator.this);
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(IWorldObjectEvent.class)) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectClassListener.class), AnnotationListenerRegistrator.this);
            }
        }

        public ObjectClassListener getAnnotation() {
            return this.method.getAnnotation(ObjectClassListener.class);
        }

        public Class getObjectClass() {
            return this.getAnnotation().objectClass();
        }

        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelB listener " + ClassUtils.getMethodSignature((Method)this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, (Object)this);
            }
        }
    }

    private class LevelCListener
    implements IWorldObjectEventListener {
        Method method;

        public LevelCListener(Method method) {
            NullCheck.check((Object)method, (String)"method");
            this.method = method;
            if (this.getAnnotation() == null) {
                throw new ListenerMethodParametersException(method, "There is no ObjectClassEventListener annotation on the method!", AnnotationListenerRegistrator.this);
            }
            if (this.getEventClass() == null) {
                throw new ListenerMethodParametersException(method, "ObjectClassEventListener.eventClass can't be null!", AnnotationListenerRegistrator.this);
            }
            if (!IWorldObjectEvent.class.isAssignableFrom(this.getEventClass())) {
                throw new ListenerMethodParametersException(method, "ObjectClassEventListener.eventClass == " + this.getEventClass() + " is not instance of IWorldObjectEvent! Are you trying to use the listener for IWorldEvent? If so, use EventListener, see the example inside ResponsiveBot PogamutUT2004!", AnnotationListenerRegistrator.this);
            }
            if (this.getObjectClass() == null) {
                throw new ListenerMethodParametersException(method, "ObjectClassEventListener.objectClass can't be null!", AnnotationListenerRegistrator.this);
            }
            if (!IWorldObject.class.isAssignableFrom(this.getObjectClass())) {
                throw new ListenerMethodParametersException(method, "ObjectClassEventListener.objectClass == " + this.getObjectClass() + " is not instance of IWorldObject! Are you trying to use the listener for IWorldEvent? If so, use EventListener, see the example inside ResponsiveBot PogamutUT2004!", AnnotationListenerRegistrator.this);
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(ObjectClassEventListener.class).eventClass())) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectClassEventListener.class), AnnotationListenerRegistrator.this);
            }
        }

        public ObjectClassEventListener getAnnotation() {
            return this.method.getAnnotation(ObjectClassEventListener.class);
        }

        public Class getEventClass() {
            return this.getAnnotation().eventClass();
        }

        public Class getObjectClass() {
            return this.getAnnotation().objectClass();
        }

        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelC listener " + ClassUtils.getMethodSignature((Method)this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, (Object)this);
            }
        }
    }

    private class LevelDListener
    implements IWorldObjectListener {
        Method method;
        WorldObjectId objectId;

        public LevelDListener(Method method) {
            NullCheck.check((Object)method, (String)"method");
            this.method = method;
            if (this.getAnnotation() == null) {
                throw new ListenerMethodParametersException(method, "There is no ObjectListener annotation on the method!", AnnotationListenerRegistrator.this);
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(IWorldObjectEvent.class)) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectListener.class), AnnotationListenerRegistrator.this);
            }
            this.objectId = AnnotationListenerRegistrator.getId(method, this.getAnnotation());
        }

        public ObjectListener getAnnotation() {
            return this.method.getAnnotation(ObjectListener.class);
        }

        public WorldObjectId getObjectId() {
            return this.objectId;
        }

        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelD listener " + ClassUtils.getMethodSignature((Method)this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, (Object)this);
            }
        }
    }

    private class LevelEListener
    implements IWorldObjectEventListener {
        Method method;
        WorldObjectId objectId;

        public LevelEListener(Method method) {
            NullCheck.check((Object)method, (String)"method");
            this.method = method;
            if (this.getAnnotation() == null) {
                throw new ListenerMethodParametersException(method, "There is no ObjectListener annotation on the method!", AnnotationListenerRegistrator.this);
            }
            if (this.getEventClass() == null) {
                throw new ListenerMethodParametersException(method, "ObjectEventListener.eventClass can't be null!", AnnotationListenerRegistrator.this);
            }
            if (!IWorldObjectEvent.class.isAssignableFrom(this.getEventClass())) {
                throw new ListenerMethodParametersException(method, "ObjectEventListener.eventClass == " + this.getEventClass() + " is not instance of IWorldObjectEvent! Are you trying to use the listener for IWorldEvent? If so, use EventListener, see the example inside ResponsiveBot PogamutUT2004!", AnnotationListenerRegistrator.this);
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(ObjectEventListener.class).eventClass())) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectEventListener.class), AnnotationListenerRegistrator.this);
            }
            this.objectId = AnnotationListenerRegistrator.getId(method, this.getAnnotation());
        }

        public ObjectEventListener getAnnotation() {
            return this.method.getAnnotation(ObjectEventListener.class);
        }

        public WorldObjectId getObjectId() {
            return this.objectId;
        }

        public Class getEventClass() {
            return this.getAnnotation().eventClass();
        }

        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelE listener " + ClassUtils.getMethodSignature((Method)this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, (Object)this);
            }
        }
    }
}

